/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.util.Collection;
import org.apache.http.util.TextUtils;

public class Args {
    /*
     * WARNING - void declaration
     */
    public static void check(boolean expression, String message) {
        if (!expression) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void check(boolean expression, String message, Object ... args) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void check(boolean expression, String message, Object arg) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T notNull(T argument, String name) {
        T t;
        if (argument == null) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        T t;
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (TextUtils.isEmpty(argument)) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be empty");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notBlank(T argument, String name) {
        T t;
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (TextUtils.isBlank(argument)) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be blank");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T containsNoBlanks(T argument, String name) {
        T t;
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (TextUtils.containsBlanks(argument)) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not contain blanks");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <E, T extends Collection<E>> T notEmpty(T argument, String name) {
        T t;
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (argument.isEmpty()) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be empty");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static int positive(int n, String name) {
        int n2;
        if (n <= 0) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be negative or zero");
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static long positive(long n, String name) {
        long l;
        if (n <= 0L) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " may not be negative or zero");
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static int notNegative(int n, String name) {
        int n2;
        if (n < 0) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " may not be negative");
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static long notNegative(long n, String name) {
        long l;
        if (n < 0L) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " may not be negative");
        }
        return l;
    }
}

