/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.Args;

@NotThreadSafe
public class SSLContextBuilder {
    static final String TLS = "TLS";
    private String protocol;
    private final Set<KeyManager> keymanagers = new LinkedHashSet<KeyManager>();
    private final Set<TrustManager> trustmanagers = new LinkedHashSet<TrustManager>();
    private SecureRandom secureRandom;

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder useProtocol(String protocol) {
        void var1_1;
        this.protocol = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        void var1_1;
        this.secureRandom = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(KeyStore truststore, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] tms = tmfactory.getTrustManagers();
        if (tms != null) {
            if (trustStrategy != null) {
                for (int i = 0; i < tms.length; ++i) {
                    TrustManager tm = tms[i];
                    if (!(tm instanceof X509TrustManager)) continue;
                    tms[i] = new TrustManagerDelegate((X509TrustManager)tm, trustStrategy);
                }
            }
            TrustManager[] arr$ = tms;
            int len$ = tms.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                void var2_3;
                TrustManager tm = arr$[i$];
                this.trustmanagers.add((TrustManager)var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        void var1_1;
        return this.loadTrustMaterial(null, (TrustStrategy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        void var3_4;
        Args.notNull(file, "Truststore file");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream instream = new FileInputStream(file);
        try {
            void var2_2;
            trustStore.load(instream, (char[])var2_2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        instream.close();
        return this.loadTrustMaterial(trustStore, (TrustStrategy)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        void var2_2;
        void var1_1;
        return this.loadTrustMaterial((File)var1_1, (char[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(File file) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        void var1_1;
        return this.loadTrustMaterial((File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        void var3_4;
        Args.notNull(url, "Truststore URL");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream instream = url.openStream();
        try {
            void var2_2;
            trustStore.load(instream, (char[])var2_2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        instream.close();
        return this.loadTrustMaterial(trustStore, (TrustStrategy)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        void var2_2;
        void var1_1;
        return this.loadTrustMaterial((URL)var1_1, (char[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keyPassword);
        KeyManager[] kms = kmfactory.getKeyManagers();
        if (kms != null) {
            if (aliasStrategy != null) {
                for (int i = 0; i < kms.length; ++i) {
                    KeyManager km = kms[i];
                    if (!(km instanceof X509ExtendedKeyManager)) continue;
                    kms[i] = new KeyManagerDelegate((X509ExtendedKeyManager)km, aliasStrategy);
                }
            }
            KeyManager[] arr$ = kms;
            int len$ = kms.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                void var3_5;
                KeyManager km = arr$[i$];
                this.keymanagers.add((KeyManager)var3_5);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        void var2_2;
        void var1_1;
        return this.loadKeyMaterial((KeyStore)var1_1, (char[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        void var3_4;
        Args.notNull(file, "Keystore file");
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream instream = new FileInputStream(file);
        try {
            void var2_2;
            identityStore.load(instream, (char[])var2_2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        instream.close();
        return this.loadKeyMaterial(identityStore, (char[])var3_4, aliasStrategy);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.loadKeyMaterial((File)var1_1, (char[])var2_2, (char[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        void var3_4;
        Args.notNull(url, "Keystore URL");
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream instream = url.openStream();
        try {
            void var2_2;
            identityStore.load(instream, (char[])var2_2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        instream.close();
        return this.loadKeyMaterial(identityStore, (char[])var3_4, aliasStrategy);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.loadKeyMaterial((URL)var1_1, (char[])var2_2, (char[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void initSSLContext(SSLContext sslcontext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        if (!keyManagers.isEmpty()) {
            void var2_2;
            void v0 = var2_2;
            keyManagerArray = v0.toArray(new KeyManager[v0.size()]);
        } else {
            keyManagerArray = null;
        }
        if (!trustManagers.isEmpty()) {
            void var3_3;
            void v2 = var3_3;
            trustManagerArray = v2.toArray(new TrustManager[v2.size()]);
        } else {
            trustManagerArray = null;
        }
        sslcontext.init(keyManagerArray, trustManagerArray, secureRandom);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        void var1_1;
        SSLContext sslcontext = SSLContext.getInstance(this.protocol != null ? this.protocol : TLS);
        this.initSSLContext(sslcontext, this.keymanagers, this.trustmanagers, this.secureRandom);
        return var1_1;
    }

    static class KeyManagerDelegate
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager keyManager;
        private final PrivateKeyStrategy aliasStrategy;

        /*
         * WARNING - void declaration
         */
        KeyManagerDelegate(X509ExtendedKeyManager keyManager, PrivateKeyStrategy aliasStrategy) {
            void var2_2;
            void var1_1;
            this.keyManager = var1_1;
            this.aliasStrategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            return this.keyManager.getClientAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Map<String, PrivateKeyDetails> getClientAliasMap(String[] keyTypes, Principal[] issuers) {
            void var3_3;
            HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
            String[] arr$ = keyTypes;
            int len$ = keyTypes.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String keyType = arr$[i$];
                String[] aliases = this.keyManager.getClientAliases(keyType, issuers);
                if (aliases == null) continue;
                String[] arr$2 = aliases;
                int len$2 = aliases.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    String alias = arr$2[i$2];
                    validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
                }
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public Map<String, PrivateKeyDetails> getServerAliasMap(String keyType, Principal[] issuers) {
            void var3_3;
            HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
            String[] aliases = this.keyManager.getServerAliases(keyType, issuers);
            if (aliases != null) {
                String[] arr$ = aliases;
                int len$ = aliases.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String alias = arr$[i$];
                    validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
                }
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            void var3_3;
            void var1_1;
            void var2_2;
            Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, (Principal[])var2_2);
            return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)var1_1, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            return this.keyManager.getServerAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            void var3_3;
            void var1_1;
            void var2_2;
            Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, (Principal[])var2_2);
            return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)var1_1, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            void var1_1;
            return this.keyManager.getCertificateChain((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PrivateKey getPrivateKey(String alias) {
            void var1_1;
            return this.keyManager.getPrivateKey((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
            void var1_1;
            void var2_2;
            Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, (Principal[])var2_2);
            return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
            void var1_1;
            void var2_2;
            Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, (Principal[])var2_2);
            return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)var1_1, null);
        }
    }

    static class TrustManagerDelegate
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private final TrustStrategy trustStrategy;

        /*
         * WARNING - void declaration
         */
        TrustManagerDelegate(X509TrustManager trustManager, TrustStrategy trustStrategy) {
            void var2_2;
            void var1_1;
            this.trustManager = var1_1;
            this.trustStrategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            void var2_2;
            void var1_1;
            this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType)) {
                void var2_2;
                void var1_1;
                this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

