/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.util.Args;

@ThreadSafe
public class UriPatternMatcher<T> {
    @GuardedBy(value="this")
    private final Map<String, T> map = new HashMap<String, T>();

    /*
     * WARNING - void declaration
     */
    public synchronized void register(String pattern, T obj) {
        void var2_2;
        void var1_1;
        Args.notNull(pattern, "URI request pattern");
        this.map.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void unregister(String pattern) {
        void var1_1;
        if (pattern == null) {
            return;
        }
        this.map.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void setHandlers(Map<String, T> map) {
        void var1_1;
        Args.notNull(map, "Map of handlers");
        this.map.clear();
        this.map.putAll((Map<String, T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void setObjects(Map<String, T> map) {
        void var1_1;
        Args.notNull(map, "Map of handlers");
        this.map.clear();
        this.map.putAll((Map<String, T>)var1_1);
    }

    @Deprecated
    public synchronized Map<String, T> getObjects() {
        return this.map;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized T lookup(String path) {
        void var2_2;
        Args.notNull(path, "Request path");
        T obj = this.map.get(path);
        if (obj == null) {
            String bestMatch = null;
            for (String pattern : this.map.keySet()) {
                if (!this.matchUriRequestPattern(pattern, path) || bestMatch != null && bestMatch.length() >= pattern.length() && (bestMatch.length() != pattern.length() || !pattern.endsWith("*"))) continue;
                obj = this.map.get(pattern);
                bestMatch = pattern;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean matchUriRequestPattern(String pattern, String path) {
        void var1_1;
        void var2_2;
        if (pattern.equals("*")) {
            return true;
        }
        return pattern.endsWith("*") && path.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && var2_2.endsWith(pattern.substring(1, var1_1.length()));
    }

    public String toString() {
        return this.map.toString();
    }
}

