/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.UriPatternMatcher;
import org.apache.http.util.Args;

@ThreadSafe
public class UriHttpRequestHandlerMapper
implements HttpRequestHandlerMapper {
    private final UriPatternMatcher<HttpRequestHandler> matcher;

    /*
     * WARNING - void declaration
     */
    protected UriHttpRequestHandlerMapper(UriPatternMatcher<HttpRequestHandler> matcher) {
        void var1_1;
        this.matcher = (UriPatternMatcher)Args.notNull(var1_1, "Pattern matcher");
    }

    public UriHttpRequestHandlerMapper() {
        this(new UriPatternMatcher<HttpRequestHandler>());
    }

    /*
     * WARNING - void declaration
     */
    public void register(String pattern, HttpRequestHandler handler) {
        void var2_2;
        void var1_1;
        Args.notNull(pattern, "Pattern");
        Args.notNull(handler, "Handler");
        this.matcher.register((String)var1_1, (HttpRequestHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void unregister(String pattern) {
        void var1_1;
        this.matcher.unregister((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String getRequestPath(HttpRequest request) {
        void var1_1;
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                void var2_2;
                uriPath = uriPath.substring(0, (int)var2_2);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpRequestHandler lookup(HttpRequest request) {
        void var1_1;
        Args.notNull(request, "HTTP request");
        return this.matcher.lookup(this.getRequestPath((HttpRequest)var1_1));
    }
}

