/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestInterceptorList;
import org.apache.http.protocol.HttpResponseInterceptorList;

@ThreadSafe
public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    /*
     * WARNING - void declaration
     */
    public ImmutableHttpProcessor(HttpRequestInterceptor[] requestInterceptors, HttpResponseInterceptor[] responseInterceptors) {
        int l;
        if (requestInterceptors != null) {
            void var1_1;
            l = requestInterceptors.length;
            this.requestInterceptors = new HttpRequestInterceptor[l];
            System.arraycopy(var1_1, 0, this.requestInterceptors, 0, l);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (responseInterceptors != null) {
            void var3_3;
            void var2_2;
            l = responseInterceptors.length;
            this.responseInterceptors = new HttpResponseInterceptor[l];
            System.arraycopy(var2_2, 0, this.responseInterceptors, 0, (int)var3_3);
            return;
        }
        this.responseInterceptors = new HttpResponseInterceptor[0];
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableHttpProcessor(List<HttpRequestInterceptor> requestInterceptors, List<HttpResponseInterceptor> responseInterceptors) {
        int l;
        if (requestInterceptors != null) {
            void var1_1;
            l = requestInterceptors.size();
            this.requestInterceptors = var1_1.toArray(new HttpRequestInterceptor[l]);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (responseInterceptors != null) {
            void var3_3;
            void var2_2;
            l = responseInterceptors.size();
            this.responseInterceptors = var2_2.toArray(new HttpResponseInterceptor[var3_3]);
            return;
        }
        this.responseInterceptors = new HttpResponseInterceptor[0];
    }

    @Deprecated
    public ImmutableHttpProcessor(HttpRequestInterceptorList requestInterceptors, HttpResponseInterceptorList responseInterceptors) {
        int i;
        int count;
        if (requestInterceptors != null) {
            count = requestInterceptors.getRequestInterceptorCount();
            this.requestInterceptors = new HttpRequestInterceptor[count];
            for (i = 0; i < count; ++i) {
                this.requestInterceptors[i] = requestInterceptors.getRequestInterceptor(i);
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (responseInterceptors != null) {
            count = responseInterceptors.getResponseInterceptorCount();
            this.responseInterceptors = new HttpResponseInterceptor[count];
            for (i = 0; i < count; ++i) {
                this.responseInterceptors[i] = responseInterceptors.getResponseInterceptor(i);
            }
            return;
        }
        this.responseInterceptors = new HttpResponseInterceptor[0];
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableHttpProcessor(HttpRequestInterceptor ... requestInterceptors) {
        this((HttpRequestInterceptor[])var1_1, (HttpResponseInterceptor[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableHttpProcessor(HttpResponseInterceptor ... responseInterceptors) {
        this((HttpRequestInterceptor[])null, (HttpResponseInterceptor[])var1_1);
        void var1_1;
    }

    @Override
    public final void process(HttpRequest request, HttpContext context) throws IOException, HttpException {
        HttpRequestInterceptor[] arr$ = this.requestInterceptors;
        int len$ = this.requestInterceptors.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HttpRequestInterceptor httpRequestInterceptor = arr$[i$];
            httpRequestInterceptor.process(request, context);
        }
    }

    @Override
    public final void process(HttpResponse response, HttpContext context) throws IOException, HttpException {
        HttpResponseInterceptor[] arr$ = this.responseInterceptors;
        int len$ = this.responseInterceptors.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HttpResponseInterceptor httpResponseInterceptor = arr$[i$];
            httpResponseInterceptor.process(response, context);
        }
    }
}

