/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.util.Args;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.EntityUtils;

@Immutable
public class HttpService {
    private volatile HttpParams params = null;
    private volatile HttpProcessor processor = null;
    private volatile HttpRequestHandlerMapper handlerMapper = null;
    private volatile ConnectionReuseStrategy connStrategy = null;
    private volatile HttpResponseFactory responseFactory = null;
    private volatile HttpExpectationVerifier expectationVerifier = null;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerResolver handlerResolver, HttpExpectationVerifier expectationVerifier, HttpParams params) {
        this((HttpProcessor)var1_1, (ConnectionReuseStrategy)var2_2, (HttpResponseFactory)var3_3, new HttpRequestHandlerResolverAdapter(handlerResolver), expectationVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
        this.params = params;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerResolver handlerResolver, HttpParams params) {
        this((HttpProcessor)var1_1, (ConnectionReuseStrategy)var2_2, (HttpResponseFactory)var3_3, new HttpRequestHandlerResolverAdapter(handlerResolver), null);
        void var3_3;
        void var2_2;
        void var1_1;
        this.params = params;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpService(HttpProcessor proc, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setHttpProcessor((HttpProcessor)var1_1);
        this.setConnReuseStrategy((ConnectionReuseStrategy)var2_2);
        this.setResponseFactory((HttpResponseFactory)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerMapper handlerMapper, HttpExpectationVerifier expectationVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.processor = (HttpProcessor)Args.notNull(var1_1, "HTTP processor");
        this.connStrategy = connStrategy != null ? var2_2 : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseFactory = responseFactory != null ? var3_3 : DefaultHttpResponseFactory.INSTANCE;
        this.handlerMapper = handlerMapper;
        this.expectationVerifier = expectationVerifier;
    }

    /*
     * WARNING - void declaration
     */
    public HttpService(HttpProcessor processor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpRequestHandlerMapper handlerMapper) {
        this((HttpProcessor)var1_1, (ConnectionReuseStrategy)var2_2, (HttpResponseFactory)var3_3, handlerMapper, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpService(HttpProcessor processor, HttpRequestHandlerMapper handlerMapper) {
        this((HttpProcessor)var1_1, null, null, (HttpRequestHandlerMapper)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setHttpProcessor(HttpProcessor processor) {
        void var1_1;
        Args.notNull(processor, "HTTP processor");
        this.processor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setConnReuseStrategy(ConnectionReuseStrategy connStrategy) {
        void var1_1;
        Args.notNull(connStrategy, "Connection reuse strategy");
        this.connStrategy = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setResponseFactory(HttpResponseFactory responseFactory) {
        void var1_1;
        Args.notNull(responseFactory, "Response factory");
        this.responseFactory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setParams(HttpParams params) {
        void var1_1;
        this.params = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        void var1_1;
        this.handlerMapper = new HttpRequestHandlerResolverAdapter((HttpRequestHandlerResolver)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        void var1_1;
        this.expectationVerifier = var1_1;
    }

    @Deprecated
    public HttpParams getParams() {
        return this.params;
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(HttpServerConnection conn, HttpContext context) throws IOException, HttpException {
        void var2_2;
        void var3_3;
        context.setAttribute("http.connection", conn);
        HttpRequest request = null;
        HttpResponse response = null;
        try {
            block13: {
                block14: {
                    request = conn.receiveRequestHeader();
                    if (!(request instanceof HttpEntityEnclosingRequest)) break block13;
                    if (!((HttpEntityEnclosingRequest)request).expectContinue()) break block14;
                    response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 100, context);
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(request, response, context);
                        }
                        catch (HttpException ex) {
                            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
                            this.handleException(ex, response);
                        }
                    }
                    if (response.getStatusLine().getStatusCode() >= 200) break block13;
                    conn.sendResponseHeader(response);
                    conn.flush();
                    response = null;
                }
                conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
            }
            context.setAttribute("http.request", request);
            if (response == null) {
                response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 200, context);
                this.processor.process(request, context);
                this.doService(request, response, context);
            }
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntity ex = ((HttpEntityEnclosingRequest)request).getEntity();
                EntityUtils.consume(ex);
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
            this.handleException(ex, response);
        }
        context.setAttribute("http.response", response);
        this.processor.process(response, context);
        conn.sendResponseHeader(response);
        if (this.canResponseHaveBody((HttpRequest)var3_3, response)) {
            conn.sendResponseEntity(response);
        }
        conn.flush();
        if (!this.connStrategy.keepAlive(response, (HttpContext)var2_2)) {
            void var1_1;
            var1_1.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        void var1_2;
        void var2_3;
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = var2_3.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && var1_2 != 205;
    }

    /*
     * WARNING - void declaration
     */
    protected void handleException(HttpException ex, HttpResponse response) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        byte[] msg = EncodingUtils.getAsciiBytes((String)var3_3);
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        var2_2.setEntity((HttpEntity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        void var2_2;
        HttpRequestHandler handler = null;
        if (this.handlerMapper != null) {
            handler = this.handlerMapper.lookup(request);
        }
        if (handler != null) {
            void var3_3;
            void var1_1;
            handler.handle((HttpRequest)var1_1, response, (HttpContext)var3_3);
            return;
        }
        var2_2.setStatusCode(501);
    }

    @Deprecated
    private static class HttpRequestHandlerResolverAdapter
    implements HttpRequestHandlerMapper {
        private final HttpRequestHandlerResolver resolver;

        /*
         * WARNING - void declaration
         */
        public HttpRequestHandlerResolverAdapter(HttpRequestHandlerResolver resolver) {
            void var1_1;
            this.resolver = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpRequestHandler lookup(HttpRequest request) {
            void var1_1;
            return this.resolver.lookup(var1_1.getRequestLine().getUri());
        }
    }
}

