/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;

@Immutable
public class HttpRequestExecutor {
    public static final int DEFAULT_WAIT_FOR_CONTINUE = 3000;
    private final int waitForContinue;

    /*
     * WARNING - void declaration
     */
    public HttpRequestExecutor(int waitForContinue) {
        void var1_1;
        this.waitForContinue = Args.positive((int)var1_1, "Wait for continue time");
    }

    public HttpRequestExecutor() {
        this(3000);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        void var1_2;
        void var2_3;
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = var2_3.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && var1_2 != 205;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        try {
            HttpResponse response = this.doSendRequest(request, conn, context);
            if (response == null) {
                void var3_3;
                void var1_1;
                response = this.doReceiveResponse((HttpRequest)var1_1, conn, (HttpContext)var3_3);
            }
            return response;
        }
        catch (IOException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (RuntimeException ex) {
            void var2_2;
            HttpRequestExecutor.closeConnection((HttpClientConnection)var2_2);
            throw ex;
        }
    }

    private static void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Args.notNull(request, "HTTP request");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        context.setAttribute("http.request", request);
        var2_2.process((HttpRequest)var1_1, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        void var3_3;
        void var2_2;
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        HttpResponse response = null;
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            boolean sendentity = true;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)request).expectContinue() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                conn.flush();
                if (conn.isResponseAvailable(this.waitForContinue)) {
                    int status;
                    response = conn.receiveResponseHeader();
                    if (this.canResponseHaveBody(request, response)) {
                        conn.receiveResponseEntity(response);
                    }
                    if ((status = response.getStatusLine().getStatusCode()) < 200) {
                        if (status != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                void var1_1;
                conn.sendRequestEntity((HttpEntityEnclosingRequest)var1_1);
            }
        }
        var2_2.flush();
        var3_3.setAttribute("http.request_sent", Boolean.TRUE);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        void var3_3;
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        HttpResponse response = null;
        int statusCode = 0;
        while (response == null || statusCode < 200) {
            response = conn.receiveResponseHeader();
            if (this.canResponseHaveBody(request, response)) {
                conn.receiveResponseEntity(response);
            }
            statusCode = response.getStatusLine().getStatusCode();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void postProcess(HttpResponse response, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Args.notNull(response, "HTTP response");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        context.setAttribute("http.response", response);
        var2_2.process((HttpResponse)var1_1, (HttpContext)var3_3);
    }
}

