/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.HttpConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@NotThreadSafe
public class HttpCoreContext
implements HttpContext {
    public static final String HTTP_CONNECTION = "http.connection";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String HTTP_TARGET_HOST = "http.target_host";
    public static final String HTTP_REQ_SENT = "http.request_sent";
    private final HttpContext context;

    public static HttpCoreContext create() {
        return new HttpCoreContext(new BasicHttpContext());
    }

    public static HttpCoreContext adapt(HttpContext context) {
        HttpContext httpContext;
        Args.notNull(context, "HTTP context");
        if (context instanceof HttpCoreContext) {
            return (HttpCoreContext)context;
        }
        return new HttpCoreContext(httpContext);
    }

    /*
     * WARNING - void declaration
     */
    public HttpCoreContext(HttpContext context) {
        void var1_1;
        this.context = var1_1;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttribute(String id) {
        void var1_1;
        return this.context.getAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttribute(String id, Object obj) {
        void var2_2;
        void var1_1;
        this.context.setAttribute((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object removeAttribute(String id) {
        void var1_1;
        return this.context.removeAttribute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getAttribute(String attribname, Class<T> clazz) {
        void var1_1;
        void var2_2;
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return var2_2.cast(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends HttpConnection> T getConnection(Class<T> clazz) {
        void var1_1;
        return (T)((HttpConnection)this.getAttribute(HTTP_CONNECTION, (Class<T>)var1_1));
    }

    public HttpConnection getConnection() {
        return this.getAttribute(HTTP_CONNECTION, HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute(HTTP_REQUEST, HttpRequest.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRequestSent() {
        void var1_1;
        Boolean b = this.getAttribute(HTTP_REQ_SENT, Boolean.class);
        return b != null && var1_1.booleanValue();
    }

    public HttpResponse getResponse() {
        return this.getAttribute(HTTP_RESPONSE, HttpResponse.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setTargetHost(HttpHost host) {
        void var1_1;
        this.setAttribute(HTTP_TARGET_HOST, var1_1);
    }

    public HttpHost getTargetHost() {
        return this.getAttribute(HTTP_TARGET_HOST, HttpHost.class);
    }
}

