/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolEntryFuture;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@NotThreadSafe
abstract class RouteSpecificPool<T, C, E extends PoolEntry<T, C>> {
    private final T route;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<PoolEntryFuture<E>> pending;

    /*
     * WARNING - void declaration
     */
    RouteSpecificPool(T route) {
        void var1_1;
        this.route = var1_1;
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
    }

    protected abstract E createEntry(C var1);

    public final T getRoute() {
        return this.route;
    }

    public int getLeasedCount() {
        return this.leased.size();
    }

    public int getPendingCount() {
        return this.pending.size();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getAllocatedCount() {
        return this.available.size() + this.leased.size();
    }

    /*
     * WARNING - void declaration
     */
    public E getFree(Object state) {
        if (!this.available.isEmpty()) {
            PoolEntry entry;
            Iterator it;
            if (state != null) {
                it = this.available.iterator();
                while (it.hasNext()) {
                    entry = (PoolEntry)it.next();
                    if (!state.equals(entry.getState())) continue;
                    it.remove();
                    this.leased.add(entry);
                    return (E)entry;
                }
            }
            it = this.available.iterator();
            while (it.hasNext()) {
                void var3_3;
                entry = (PoolEntry)it.next();
                if (entry.getState() != null) continue;
                it.remove();
                this.leased.add(entry);
                return var3_3;
            }
        }
        return null;
    }

    public E getLastUsed() {
        if (!this.available.isEmpty()) {
            return (E)((PoolEntry)this.available.getLast());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(E entry) {
        void var1_1;
        Args.notNull(entry, "Pool entry");
        return this.available.remove(entry) || this.leased.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void free(E entry, boolean reusable) {
        void var2_2;
        Args.notNull(entry, "Pool entry");
        boolean bl = this.leased.remove(entry);
        Asserts.check(bl, "Entry %s has not been leased from this pool", entry);
        if (var2_2 != false) {
            void var1_1;
            this.available.addFirst(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public E add(C conn) {
        void var1_1;
        E entry = this.createEntry(conn);
        this.leased.add(entry);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void queue(PoolEntryFuture<E> future) {
        void var1_1;
        if (future == null) {
            return;
        }
        this.pending.add((PoolEntryFuture<void>)var1_1);
    }

    public PoolEntryFuture<E> nextPending() {
        return this.pending.poll();
    }

    /*
     * WARNING - void declaration
     */
    public void unqueue(PoolEntryFuture<E> future) {
        void var1_1;
        if (future == null) {
            return;
        }
        this.pending.remove(var1_1);
    }

    public void shutdown() {
        for (PoolEntryFuture object : this.pending) {
            object.cancel(true);
        }
        this.pending.clear();
        for (PoolEntry poolEntry : this.available) {
            poolEntry.close();
        }
        this.available.clear();
        for (PoolEntry poolEntry : this.leased) {
            poolEntry.close();
        }
        this.leased.clear();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[route: ");
        buffer.append(this.route);
        buffer.append("][leased: ");
        buffer.append(this.leased.size());
        buffer.append("][available: ");
        buffer.append(this.available.size());
        buffer.append("][pending: ");
        buffer.append(this.pending.size());
        buffer.append("]");
        return var1_1.toString();
    }
}

