/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.Args;

@ThreadSafe
abstract class PoolEntryFuture<T>
implements Future<T> {
    private final Lock lock;
    private final FutureCallback<T> callback;
    private final Condition condition;
    private volatile boolean cancelled;
    private volatile boolean completed;
    private T result;

    /*
     * WARNING - void declaration
     */
    PoolEntryFuture(Lock lock, FutureCallback<T> callback) {
        void var2_2;
        void var1_1;
        this.lock = lock;
        this.condition = var1_1.newCondition();
        this.callback = var2_2;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.cancelled = true;
            if (this.callback != null) {
                this.callback.cancelled();
            }
            this.condition.signalAll();
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            void var1_1;
            throw new ExecutionException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get(long timeout222, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Args.notNull(unit, "Time unit");
        this.lock.lock();
        try {
            void var3_6;
            long timeout222;
            if (this.completed) {
                T timeout222 = this.result;
                return timeout222;
            }
            this.result = this.getPoolEntry(timeout222, (TimeUnit)var3_6);
            this.completed = true;
            if (this.callback != null) {
                this.callback.completed(this.result);
            }
            T timeout222 = this.result;
            return timeout222;
        }
        catch (IOException ex) {
            void var1_4;
            this.completed = true;
            this.result = null;
            if (this.callback != null) {
                this.callback.failed(ex);
            }
            throw new ExecutionException((Throwable)var1_4);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract T getPoolEntry(long var1, TimeUnit var3) throws IOException, InterruptedException, TimeoutException;

    /*
     * WARNING - void declaration
     */
    public boolean await(Date deadline) throws InterruptedException {
        this.lock.lock();
        try {
            void var1_2;
            boolean success;
            if (this.cancelled) {
                throw new InterruptedException("Operation interrupted");
            }
            if (deadline != null) {
                success = this.condition.awaitUntil(deadline);
            } else {
                this.condition.await();
                success = true;
            }
            if (this.cancelled) {
                throw new InterruptedException("Operation interrupted");
            }
            return (boolean)var1_2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void wakeup() {
        this.lock.lock();
        try {
            this.condition.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }
}

