/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.util.Args;

@ThreadSafe
public abstract class PoolEntry<T, C> {
    private final String id;
    private final T route;
    private final C conn;
    private final long created;
    private final long validityDeadline;
    @GuardedBy(value="this")
    private long updated;
    @GuardedBy(value="this")
    private long expiry;
    private volatile Object state;

    /*
     * WARNING - void declaration
     */
    public PoolEntry(String id, T route, C conn, long timeToLive, TimeUnit tunit) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull(route, "Route");
        Args.notNull(conn, "Connection");
        Args.notNull(tunit, "Time unit");
        this.id = var1_1;
        this.route = var2_2;
        this.conn = var3_3;
        this.created = System.currentTimeMillis();
        this.validityDeadline = timeToLive > 0L ? this.created + tunit.toMillis(timeToLive) : Long.MAX_VALUE;
        this.expiry = this.validityDeadline;
    }

    /*
     * WARNING - void declaration
     */
    public PoolEntry(String id, T route, C conn) {
        this((String)var1_1, var2_2, var3_3, 0L, TimeUnit.MILLISECONDS);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public String getId() {
        return this.id;
    }

    public T getRoute() {
        return this.route;
    }

    public C getConnection() {
        return this.conn;
    }

    public long getCreated() {
        return this.created;
    }

    public long getValidityDeadline() {
        return this.validityDeadline;
    }

    @Deprecated
    public long getValidUnit() {
        return this.validityDeadline;
    }

    public Object getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(Object state) {
        void var1_1;
        this.state = var1_1;
    }

    public synchronized long getUpdated() {
        return this.updated;
    }

    public synchronized long getExpiry() {
        return this.expiry;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void updateExpiry(long time, TimeUnit tunit) {
        void var1_1;
        void var3_2;
        Args.notNull(tunit, "Time unit");
        this.updated = System.currentTimeMillis();
        long newExpiry = time > 0L ? this.updated + var3_2.toMillis((long)var1_1) : Long.MAX_VALUE;
        this.expiry = Math.min(newExpiry, this.validityDeadline);
    }

    public synchronized boolean isExpired(long now) {
        return now >= this.expiry;
    }

    public abstract void close();

    public abstract boolean isClosed();

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[id:");
        buffer.append(this.id);
        buffer.append("][route:");
        buffer.append(this.route);
        buffer.append("][state:");
        buffer.append(this.state);
        buffer.append("]");
        return var1_1.toString();
    }
}

