/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.pool.ConnFactory;
import org.apache.http.pool.ConnPool;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolEntryCallback;
import org.apache.http.pool.PoolEntryFuture;
import org.apache.http.pool.PoolStats;
import org.apache.http.pool.RouteSpecificPool;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@ThreadSafe
public abstract class AbstractConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPool<T, E>,
ConnPoolControl<T> {
    private final Lock lock;
    private final ConnFactory<T, C> connFactory;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<PoolEntryFuture<E>> pending;
    private final Map<T, Integer> maxPerRoute;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;
    private volatile int validateAfterInactivity;

    /*
     * WARNING - void declaration
     */
    public AbstractConnPool(ConnFactory<T, C> connFactory, int defaultMaxPerRoute, int maxTotal) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.connFactory = (ConnFactory)Args.notNull(var1_1, "Connection factory");
        this.defaultMaxPerRoute = Args.positive((int)var2_2, "Max per route value");
        this.maxTotal = Args.positive((int)var3_3, "Max total value");
        this.lock = new ReentrantLock();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
    }

    protected abstract E createEntry(T var1, C var2);

    protected void onLease(E entry) {
    }

    protected void onRelease(E entry) {
    }

    protected void onReuse(E entry) {
    }

    protected boolean validate(E entry) {
        return true;
    }

    public boolean isShutdown() {
        return this.isShutDown;
    }

    public void shutdown() throws IOException {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (PoolEntry object : this.available) {
                object.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.available.clear();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private RouteSpecificPool<T, C, E> getPool(T route) {
        void var2_2;
        RouteSpecificPool pool = this.routeToPool.get(route);
        if (pool == null) {
            void var1_1;
            final T t = route;
            pool = new RouteSpecificPool<T, C, E>(t){
                {
                    void var2_2;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected E createEntry(C conn) {
                    void var1_1;
                    return AbstractConnPool.this.createEntry(t, var1_1);
                }
            };
            this.routeToPool.put(var1_1, pool);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<E> lease(T route, Object state, FutureCallback<E> callback) {
        void var2_2;
        void var1_1;
        void var3_3;
        Args.notNull(route, "Route");
        Asserts.check(!this.isShutDown, "Connection pool shut down");
        AbstractConnPool abstractConnPool = this;
        return new PoolEntryFuture<E>(abstractConnPool.lock, (FutureCallback)var3_3){
            {
                void var3_3;
                void var2_22;
                super((Lock)var2_22, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public E getPoolEntry(long timeout, TimeUnit tunit) throws InterruptedException, TimeoutException, IOException {
                void var1_2;
                void var3_3;
                PoolEntry entry = AbstractConnPool.access$000(AbstractConnPool.this, var1_1, var2_2, timeout, (TimeUnit)var3_3, this);
                AbstractConnPool.this.onLease(entry);
                return var1_2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Future<E> lease(T route, Object state) {
        void var2_2;
        void var1_1;
        return this.lease(var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private E getPoolEntryBlocking(T route, Object state2, long timeout, TimeUnit tunit, PoolEntryFuture<E> future) throws IOException, InterruptedException, TimeoutException {
        Date deadline = null;
        if (timeout > 0L) {
            deadline = new Date(System.currentTimeMillis() + tunit.toMillis(timeout));
        }
        this.lock.lock();
        try {
            RouteSpecificPool pool = this.getPool(route);
            Object entry = null;
            while (entry == null) {
                boolean success;
                int totalUsed;
                int freeCapacity;
                Asserts.check(!this.isShutDown, "Connection pool shut down");
                while (true) {
                    E e = pool.getFree(state2);
                    entry = e;
                    if (e == null) break;
                    if (((PoolEntry)entry).isExpired(System.currentTimeMillis())) {
                        ((PoolEntry)entry).close();
                    } else if (this.validateAfterInactivity > 0 && ((PoolEntry)entry).getUpdated() + (long)this.validateAfterInactivity <= System.currentTimeMillis() && !this.validate(entry)) {
                        ((PoolEntry)entry).close();
                    }
                    if (!((PoolEntry)entry).isClosed()) break;
                    this.available.remove(entry);
                    pool.free(entry, false);
                }
                if (entry != null) {
                    this.available.remove(entry);
                    this.leased.add((PoolEntry)entry);
                    this.onReuse(entry);
                    tunit = entry;
                    return (E)tunit;
                }
                int maxPerRoute = this.getMax(route);
                int excess = Math.max(0, pool.getAllocatedCount() + 1 - maxPerRoute);
                if (excess > 0) {
                    E lastUsed;
                    for (int i = 0; i < excess && (lastUsed = pool.getLastUsed()) != null; ++i) {
                        ((PoolEntry)lastUsed).close();
                        this.available.remove(lastUsed);
                        pool.remove(lastUsed);
                    }
                }
                if (pool.getAllocatedCount() < maxPerRoute && (freeCapacity = Math.max(this.maxTotal - (totalUsed = this.leased.size()), 0)) > 0) {
                    void var2_7;
                    int state2 = this.available.size();
                    if (state2 > freeCapacity - 1 && !this.available.isEmpty()) {
                        PoolEntry lastUsed = (PoolEntry)this.available.removeLast();
                        lastUsed.close();
                        entry = this.getPool(lastUsed.getRoute());
                        ((RouteSpecificPool)entry).remove(lastUsed);
                    }
                    C conn = this.connFactory.create(route);
                    entry = pool.add(var2_7);
                    this.leased.add((PoolEntry)entry);
                    return (E)entry;
                }
                try {
                    pool.queue(future);
                    this.pending.add(future);
                    success = future.await(deadline);
                }
                finally {
                    pool.unqueue(future);
                    this.pending.remove(future);
                }
                if (success || deadline == null || deadline.getTime() > System.currentTimeMillis()) continue;
            }
            throw new TimeoutException("Timeout waiting for connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void release(E entry, boolean reusable) {
        this.lock.lock();
        try {
            if (this.leased.remove(entry)) {
                void var3_4;
                void var2_3;
                RouteSpecificPool pool = this.getPool(((PoolEntry)entry).getRoute());
                pool.free(entry, reusable);
                if (var2_3 != false && !this.isShutDown) {
                    this.available.addFirst(entry);
                    this.onRelease(entry);
                } else {
                    ((PoolEntry)entry).close();
                }
                PoolEntryFuture future = var3_4.nextPending();
                if (future != null) {
                    this.pending.remove(future);
                } else {
                    future = this.pending.poll();
                }
                if (future != null) {
                    void var1_1;
                    var1_1.wakeup();
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMax(T route) {
        Integer v = this.maxPerRoute.get(route);
        if (v != null) {
            void var1_1;
            return var1_1.intValue();
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxTotal(int max) {
        Args.positive(max, "Max value");
        this.lock.lock();
        try {
            void var1_1;
            this.maxTotal = var1_1;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n = this.maxTotal;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDefaultMaxPerRoute(int max) {
        Args.positive(max, "Max per route value");
        this.lock.lock();
        try {
            void var1_1;
            this.defaultMaxPerRoute = var1_1;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n = this.defaultMaxPerRoute;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxPerRoute(T route, int max) {
        Args.notNull(route, "Route");
        Args.positive(max, "Max per route value");
        this.lock.lock();
        try {
            void var2_3;
            void var1_1;
            this.maxPerRoute.put(var1_1, (int)var2_3);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMaxPerRoute(T route) {
        Args.notNull(route, "Route");
        this.lock.lock();
        try {
            void var1_1;
            int n = this.getMax(var1_1);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PoolStats getStats(T route) {
        Args.notNull(route, "Route");
        this.lock.lock();
        try {
            PoolStats poolStats;
            void var2_3;
            RouteSpecificPool<T, C, E> pool = this.getPool(route);
            poolStats = new PoolStats(pool.getLeasedCount(), pool.getPendingCount(), var2_3.getAvailableCount(), this.getMax(poolStats));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<T> getRoutes() {
        this.lock.lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.routeToPool.keySet());
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void enumAvailable(PoolEntryCallback<T, C> callback) {
        this.lock.lock();
        try {
            Iterator it = this.available.iterator();
            while (it.hasNext()) {
                void var3_4;
                PoolEntry entry = (PoolEntry)it.next();
                callback.process(entry);
                if (!entry.isClosed()) continue;
                RouteSpecificPool routeSpecificPool = this.getPool(entry.getRoute());
                routeSpecificPool.remove(var3_4);
                it.remove();
            }
            this.purgePoolMap();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void enumLeased(PoolEntryCallback<T, C> callback) {
        this.lock.lock();
        try {
            for (PoolEntry entry : this.leased) {
                void var3_4;
                callback.process((PoolEntry<T, C>)var3_4);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, RouteSpecificPool<T, C, E>>> it = this.routeToPool.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, RouteSpecificPool<T, C, E>> entry = it.next();
            RouteSpecificPool<T, C, E> pool = entry.getValue();
            if (pool.getPendingCount() + ((RouteSpecificPool)((Object)entry)).getAllocatedCount() != 0) continue;
            it.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closeIdle(long idletime, TimeUnit tunit) {
        void var1_1;
        void var3_2;
        Args.notNull(tunit, "Time unit");
        long time = var3_2.toMillis((long)var1_1);
        if (time < 0L) {
            time = 0L;
        }
        final long deadline = System.currentTimeMillis() - time;
        this.enumAvailable(new PoolEntryCallback<T, C>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void process(PoolEntry<T, C> entry) {
                if (entry.getUpdated() <= deadline) {
                    void var1_1;
                    var1_1.close();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void closeExpired() {
        void var1_1;
        long now = System.currentTimeMillis();
        this.enumAvailable(new PoolEntryCallback<T, C>((long)var1_1){
            final /* synthetic */ long val$now;
            {
                this.val$now = l;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void process(PoolEntry<T, C> entry) {
                if (entry.isExpired(this.val$now)) {
                    void var1_1;
                    var1_1.close();
                }
            }
        });
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    /*
     * WARNING - void declaration
     */
    public void setValidateAfterInactivity(int ms) {
        void var1_1;
        this.validateAfterInactivity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[leased: ");
        buffer.append(this.leased);
        buffer.append("][available: ");
        buffer.append(this.available);
        buffer.append("][pending: ");
        buffer.append(this.pending);
        buffer.append("]");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ PoolEntry access$000(AbstractConnPool x0, Object x1, Object x2, long x3, TimeUnit x4, PoolEntryFuture x5) throws IOException, InterruptedException, TimeoutException {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.getPoolEntryBlocking(var1_1, var2_2, (long)var3_3, x4, x5);
    }
}

