/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicListHeaderIterator;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class HeaderGroup
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2608834160639271617L;
    private final Header[] EMPTY = new Header[0];
    private final List<Header> headers = new ArrayList<Header>(16);

    public void clear() {
        this.headers.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void addHeader(Header header) {
        void var1_1;
        if (header == null) {
            return;
        }
        this.headers.add((Header)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeHeader(Header header) {
        void var1_1;
        if (header == null) {
            return;
        }
        this.headers.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void updateHeader(Header header) {
        void var1_1;
        if (header == null) {
            return;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header2 = this.headers.get(i);
            if (!header2.getName().equalsIgnoreCase(header.getName())) continue;
            this.headers.set(i, header);
            return;
        }
        this.headers.add((Header)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setHeaders(Header[] headers) {
        void var1_1;
        this.clear();
        if (headers == null) {
            return;
        }
        Collections.addAll(this.headers, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Header getCondensedHeader(String name) {
        void var3_3;
        void var1_1;
        Header[] hdrs = this.getHeaders(name);
        if (hdrs.length == 0) {
            return null;
        }
        if (hdrs.length == 1) {
            return hdrs[0];
        }
        CharArrayBuffer valueBuffer = new CharArrayBuffer(128);
        valueBuffer.append(hdrs[0].getValue());
        for (int i = 1; i < hdrs.length; ++i) {
            valueBuffer.append(", ");
            valueBuffer.append(hdrs[i].getValue());
        }
        return new BasicHeader(var1_1.toLowerCase(Locale.ROOT), var3_3.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Header[] getHeaders(String name) {
        ArrayList<Header> headersFound = null;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            if (headersFound == null) {
                headersFound = new ArrayList<Header>();
            }
            headersFound.add(header);
        }
        if (headersFound != null) {
            void var2_2;
            void v0 = var2_2;
            return v0.toArray(new Header[v0.size()]);
        }
        return this.EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public Header getFirstHeader(String name) {
        for (int i = 0; i < this.headers.size(); ++i) {
            void var3_3;
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Header getLastHeader(String name) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            void var3_3;
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return var3_3;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public boolean containsHeader(String name) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public HeaderIterator iterator() {
        return new BasicListHeaderIterator(this.headers, null);
    }

    /*
     * WARNING - void declaration
     */
    public HeaderIterator iterator(String name) {
        void var1_1;
        return new BasicListHeaderIterator(this.headers, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HeaderGroup copy() {
        void var1_1;
        HeaderGroup clone = new HeaderGroup();
        clone.headers.addAll(this.headers);
        return var1_1;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.headers.toString();
    }
}

