/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.HeaderIterator;
import org.apache.http.ParseException;
import org.apache.http.TokenIterator;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicTokenIterator
implements TokenIterator {
    public static final String HTTP_SEPARATORS = " ,;=()<>@:\\\"/[]?{}\t";
    protected final HeaderIterator headerIt;
    protected String currentHeader;
    protected String currentToken;
    protected int searchPos;

    /*
     * WARNING - void declaration
     */
    public BasicTokenIterator(HeaderIterator headerIterator) {
        void var1_1;
        this.headerIt = (HeaderIterator)Args.notNull(var1_1, "Header iterator");
        this.searchPos = this.findNext(-1);
    }

    @Override
    public boolean hasNext() {
        return this.currentToken != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String nextToken() throws NoSuchElementException, ParseException {
        void var1_1;
        if (this.currentToken == null) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        String result = this.currentToken;
        this.searchPos = this.findNext(this.searchPos);
        return var1_1;
    }

    @Override
    public final Object next() throws NoSuchElementException, ParseException {
        return this.nextToken();
    }

    @Override
    public final void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing tokens is not supported.");
    }

    /*
     * WARNING - void declaration
     */
    protected int findNext(int pos) throws ParseException {
        void var2_2;
        void var1_1;
        int from = pos;
        if (from < 0) {
            if (!this.headerIt.hasNext()) {
                return -1;
            }
            this.currentHeader = this.headerIt.nextHeader().getValue();
            from = 0;
        } else {
            from = this.findTokenSeparator(from);
        }
        int start = this.findTokenStart(from);
        if (start < 0) {
            this.currentToken = null;
            return -1;
        }
        int end = this.findTokenEnd(start);
        this.currentToken = this.createToken(this.currentHeader, (int)var1_1, end);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String createToken(String value, int start, int end) {
        void var3_3;
        void var2_2;
        return value.substring((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected int findTokenStart(int pos) {
        void var2_2;
        int from = Args.notNegative(pos, "Search position");
        boolean found = false;
        while (!found && this.currentHeader != null) {
            int to = this.currentHeader.length();
            while (!found && from < to) {
                char ch = this.currentHeader.charAt(from);
                if (this.isTokenSeparator(ch) || this.isWhitespace(ch)) {
                    ++from;
                    continue;
                }
                BasicTokenIterator basicTokenIterator = this;
                if (basicTokenIterator.isTokenChar(basicTokenIterator.currentHeader.charAt(from))) {
                    found = true;
                    continue;
                }
                throw new ParseException("Invalid character before token (pos " + from + "): " + this.currentHeader);
            }
            if (found) continue;
            if (this.headerIt.hasNext()) {
                this.currentHeader = this.headerIt.nextHeader().getValue();
                from = 0;
                continue;
            }
            this.currentHeader = null;
        }
        if (var2_2 != false) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected int findTokenSeparator(int pos) {
        void var1_1;
        int from = Args.notNegative(pos, "Search position");
        boolean found = false;
        int to = this.currentHeader.length();
        while (!found && from < to) {
            char ch = this.currentHeader.charAt(from);
            if (this.isTokenSeparator(ch)) {
                found = true;
                continue;
            }
            if (this.isWhitespace(ch)) {
                ++from;
                continue;
            }
            if (this.isTokenChar(ch)) {
                throw new ParseException("Tokens without separator (pos " + from + "): " + this.currentHeader);
            }
            throw new ParseException("Invalid character after token (pos " + from + "): " + this.currentHeader);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int findTokenEnd(int from) {
        void var1_1;
        Args.notNegative(from, "Search position");
        int to = this.currentHeader.length();
        for (int end = from + 1; end < to; ++end) {
            BasicTokenIterator basicTokenIterator = this;
            if (!basicTokenIterator.isTokenChar(basicTokenIterator.currentHeader.charAt(end))) break;
        }
        return (int)var1_1;
    }

    protected boolean isTokenSeparator(char ch) {
        return ch == ',';
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isWhitespace(char ch) {
        void var1_1;
        return ch == '\t' || Character.isSpaceChar((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isTokenChar(char ch) {
        void var1_1;
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (Character.isISOControl(ch)) {
            return false;
        }
        return !this.isHttpSeparator((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isHttpSeparator(char ch) {
        void var1_1;
        return HTTP_SEPARATORS.indexOf((int)var1_1) >= 0;
    }
}

