/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.Serializable;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicLineFormatter;
import org.apache.http.util.Args;

@Immutable
public class BasicStatusLine
implements Serializable,
Cloneable,
StatusLine {
    private static final long serialVersionUID = -2443303766890459269L;
    private final ProtocolVersion protoVersion;
    private final int statusCode;
    private final String reasonPhrase;

    /*
     * WARNING - void declaration
     */
    public BasicStatusLine(ProtocolVersion version, int statusCode, String reasonPhrase) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.protoVersion = (ProtocolVersion)Args.notNull(var1_1, "Version");
        this.statusCode = Args.notNegative((int)var2_2, "Status code");
        this.reasonPhrase = var3_3;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protoVersion;
    }

    @Override
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatStatusLine(null, this).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

