/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@NotThreadSafe
public class BasicListHeaderIterator
implements HeaderIterator {
    protected final List<Header> allHeaders;
    protected int currentIndex;
    protected int lastIndex;
    protected String headerName;

    /*
     * WARNING - void declaration
     */
    public BasicListHeaderIterator(List<Header> headers, String name) {
        void var2_2;
        void var1_1;
        this.allHeaders = (List)Args.notNull(var1_1, "Header list");
        this.headerName = var2_2;
        this.currentIndex = this.findNext(-1);
        this.lastIndex = -1;
    }

    /*
     * WARNING - void declaration
     */
    protected int findNext(int pos) {
        void var3_3;
        int from = pos;
        if (from < -1) {
            return -1;
        }
        int to = this.allHeaders.size() - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filterHeader(++from);
        }
        if (var3_3 != false) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean filterHeader(int index) {
        void var1_2;
        if (this.headerName == null) {
            return true;
        }
        String name = this.allHeaders.get(index).getName();
        return this.headerName.equalsIgnoreCase((String)var1_2);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header nextHeader() throws NoSuchElementException {
        void var1_1;
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.lastIndex = current;
        this.currentIndex = this.findNext(current);
        return this.allHeaders.get((int)var1_1);
    }

    @Override
    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        Asserts.check(this.lastIndex >= 0, "No header to remove");
        this.allHeaders.remove(this.lastIndex);
        this.lastIndex = -1;
        --this.currentIndex;
    }
}

