/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicLineParser
implements LineParser {
    @Deprecated
    public static final BasicLineParser DEFAULT = new BasicLineParser();
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    protected final ProtocolVersion protocol;

    /*
     * WARNING - void declaration
     */
    public BasicLineParser(ProtocolVersion proto) {
        void var1_1;
        this.protocol = proto != null ? var1_1 : HttpVersion.HTTP_1_1;
    }

    public BasicLineParser() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolVersion parseProtocolVersion(String value, LineParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseProtocolVersion((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        void var3_4;
        void var2_2;
        int minor;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        this.skipWhitespace(buffer, cursor);
        int i = cursor.getPos();
        if (i + protolength + 4 > indexTo) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(i + j) == protoname.charAt(j);
        }
        if (ok) {
            boolean bl = ok = buffer.charAt(i + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        int period = buffer.indexOf(46, i += protolength + 1, indexTo);
        if (period == -1) {
            throw new ParseException("Invalid protocol version number: " + buffer.substring(indexFrom, indexTo));
        }
        try {
            int major = Integer.parseInt(buffer.substringTrimmed(i, period));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid protocol major version number: " + buffer.substring(indexFrom, indexTo));
        }
        i = period + 1;
        int blank = buffer.indexOf(32, i, indexTo);
        if (blank == -1) {
            blank = indexTo;
        }
        try {
            minor = Integer.parseInt(buffer.substringTrimmed(i, blank));
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            throw new ParseException("Invalid protocol minor version number: " + var1_1.substring(indexFrom, indexTo));
        }
        var2_2.updatePos(blank);
        return this.createProtocolVersion((int)var3_4, minor);
    }

    /*
     * WARNING - void declaration
     */
    protected ProtocolVersion createProtocolVersion(int major, int minor) {
        void var2_2;
        void var1_1;
        return this.protocol.forVersion((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
        int index;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        if (buffer.length() < protolength + 4) {
            return false;
        }
        if (index < 0) {
            index = buffer.length() - 4 - protolength;
        } else if (index == 0) {
            for (index = cursor.getPos(); index < buffer.length() && HTTP.isWhitespace(buffer.charAt(index)); ++index) {
            }
        }
        if (index + protolength + 4 > buffer.length()) {
            return false;
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(index + j) == protoname.charAt(j);
        }
        if (ok) {
            void var2_3;
            void var1_1;
            ok = var1_1.charAt((int)(var2_3 + protolength)) == '/';
        }
        return ok;
    }

    /*
     * WARNING - void declaration
     */
    public static RequestLine parseRequestLine(String value, LineParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseRequestLine((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RequestLine parseRequestLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            void var2_2;
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String method = buffer.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            this.skipWhitespace(buffer, cursor);
            i = cursor.getPos();
            blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String uri = buffer.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
            this.skipWhitespace(buffer, cursor);
            if (!var2_2.atEnd()) {
                throw new ParseException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            return this.createRequestLine(method, uri, ver);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            void var3_3;
            void var1_1;
            throw new ParseException("Invalid request line: " + var1_1.substring((int)var3_3, indexTo));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RequestLine createRequestLine(String method, String uri, ProtocolVersion ver) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BasicRequestLine((String)var1_1, (String)var2_2, (ProtocolVersion)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static StatusLine parseStatusLine(String value, LineParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseStatusLine((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StatusLine parseStatusLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            int statusCode;
            ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            String s = buffer.substringTrimmed(i, blank);
            for (int j = 0; j < s.length(); ++j) {
                if (Character.isDigit(s.charAt(j))) continue;
                throw new ParseException("Status line contains invalid status code: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                void var2_4;
                statusCode = Integer.parseInt((String)var2_4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Status line contains invalid status code: " + buffer.substring(indexFrom, indexTo));
            }
            int n = blank;
            String reasonPhrase = n < indexTo ? buffer.substringTrimmed(n, indexTo) : "";
            return this.createStatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            void var3_6;
            void var1_1;
            throw new ParseException("Invalid status line: " + var1_1.substring((int)var3_6, indexTo));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected StatusLine createStatusLine(ProtocolVersion ver, int status, String reason) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BasicStatusLine((ProtocolVersion)var1_1, (int)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Header parseHeader(String value, LineParser parser) throws ParseException {
        void var2_2;
        void var1_1;
        String string;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(string);
        return (parser != null ? var1_1 : INSTANCE).parseHeader((CharArrayBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header parseHeader(CharArrayBuffer buffer) throws ParseException {
        void var1_1;
        return new BufferedHeader((CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void skipWhitespace(CharArrayBuffer buffer, ParserCursor cursor) {
        void var3_3;
        void var2_2;
        int indexTo = cursor.getUpperBound();
        for (int pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(buffer.charAt(pos)); ++pos) {
        }
        var2_2.updatePos((int)var3_3);
    }
}

