/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicLineFormatter
implements LineFormatter {
    @Deprecated
    public static final BasicLineFormatter DEFAULT = new BasicLineFormatter();
    public static final BasicLineFormatter INSTANCE = new BasicLineFormatter();

    /*
     * WARNING - void declaration
     */
    protected CharArrayBuffer initBuffer(CharArrayBuffer charBuffer) {
        void var1_1;
        CharArrayBuffer buffer = charBuffer;
        if (buffer != null) {
            buffer.clear();
        } else {
            buffer = new CharArrayBuffer(64);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatProtocolVersion(ProtocolVersion version, LineFormatter formatter) {
        ProtocolVersion protocolVersion;
        void var1_1;
        return (formatter != null ? var1_1 : INSTANCE).appendProtocolVersion(null, protocolVersion).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer appendProtocolVersion(CharArrayBuffer buffer, ProtocolVersion version) {
        void var1_1;
        void var2_2;
        CharArrayBuffer result;
        Args.notNull(version, "Protocol version");
        int len = this.estimateProtocolVersionLen(version);
        if (result == null) {
            result = new CharArrayBuffer(len);
        } else {
            void var3_3;
            result.ensureCapacity((int)var3_3);
        }
        result.append(version.getProtocol());
        result.append('/');
        result.append(Integer.toString(version.getMajor()));
        result.append('.');
        result.append(Integer.toString(var2_2.getMinor()));
        return var1_1;
    }

    protected int estimateProtocolVersionLen(ProtocolVersion version) {
        return version.getProtocol().length() + 4;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatRequestLine(RequestLine reqline, LineFormatter formatter) {
        RequestLine requestLine;
        void var1_1;
        return (formatter != null ? var1_1 : INSTANCE).formatRequestLine(null, requestLine).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatRequestLine(CharArrayBuffer buffer, RequestLine reqline) {
        void var1_1;
        void var2_2;
        Args.notNull(reqline, "Request line");
        CharArrayBuffer result = this.initBuffer(buffer);
        this.doFormatRequestLine(result, (RequestLine)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFormatRequestLine(CharArrayBuffer buffer, RequestLine reqline) {
        void var2_2;
        void var1_1;
        void var3_3;
        String method = reqline.getMethod();
        String uri = reqline.getUri();
        int len = method.length() + 1 + uri.length() + 1 + this.estimateProtocolVersionLen(reqline.getProtocolVersion());
        buffer.ensureCapacity(len);
        buffer.append((String)var3_3);
        buffer.append(' ');
        buffer.append(uri);
        buffer.append(' ');
        this.appendProtocolVersion((CharArrayBuffer)var1_1, var2_2.getProtocolVersion());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatStatusLine(StatusLine statline, LineFormatter formatter) {
        StatusLine statusLine;
        void var1_1;
        return (formatter != null ? var1_1 : INSTANCE).formatStatusLine(null, statusLine).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatStatusLine(CharArrayBuffer buffer, StatusLine statline) {
        void var1_1;
        void var2_2;
        Args.notNull(statline, "Status line");
        CharArrayBuffer result = this.initBuffer(buffer);
        this.doFormatStatusLine(result, (StatusLine)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFormatStatusLine(CharArrayBuffer buffer, StatusLine statline) {
        void var2_2;
        void var3_3;
        int len = this.estimateProtocolVersionLen(statline.getProtocolVersion()) + 1 + 3 + 1;
        String reason = statline.getReasonPhrase();
        if (reason != null) {
            len += reason.length();
        }
        buffer.ensureCapacity((int)var3_3);
        this.appendProtocolVersion(buffer, statline.getProtocolVersion());
        buffer.append(' ');
        buffer.append(Integer.toString(var2_2.getStatusCode()));
        buffer.append(' ');
        if (reason != null) {
            void var1_1;
            var1_1.append(reason);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String formatHeader(Header header, LineFormatter formatter) {
        Header header2;
        void var1_1;
        return (formatter != null ? var1_1 : INSTANCE).formatHeader(null, header2).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatHeader(CharArrayBuffer buffer, Header header) {
        void var1_1;
        CharArrayBuffer result;
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            result = ((FormattedHeader)header).getBuffer();
        } else {
            void var2_2;
            result = this.initBuffer(result);
            this.doFormatHeader(result, (Header)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFormatHeader(CharArrayBuffer buffer, Header header) {
        void var3_3;
        String name = header.getName();
        String value = header.getValue();
        int len = name.length() + 2;
        if (value != null) {
            len += value.length();
        }
        buffer.ensureCapacity(len);
        buffer.append((String)var3_3);
        buffer.append(": ");
        if (value != null) {
            void var2_2;
            void var1_1;
            var1_1.append((String)var2_2);
        }
    }
}

