/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    /*
     * WARNING - void declaration
     */
    public BasicHttpResponse(StatusLine statusline, ReasonPhraseCatalog catalog, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.statusline = Args.notNull(statusline, "Status line");
        this.ver = statusline.getProtocolVersion();
        this.code = statusline.getStatusCode();
        this.reasonPhrase = var1_1.getReasonPhrase();
        this.reasonCatalog = var2_2;
        this.locale = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpResponse(StatusLine statusline) {
        void var1_1;
        this.statusline = Args.notNull(statusline, "Status line");
        this.ver = statusline.getProtocolVersion();
        this.code = statusline.getStatusCode();
        this.reasonPhrase = var1_1.getReasonPhrase();
        this.reasonCatalog = null;
        this.locale = null;
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpResponse(ProtocolVersion ver, int code, String reason) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNegative(code, "Status code");
        this.statusline = null;
        this.ver = var1_1;
        this.code = var2_2;
        this.reasonPhrase = var3_3;
        this.reasonCatalog = null;
        this.locale = null;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    @Override
    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            String string;
            ProtocolVersion protocolVersion = this.ver != null ? this.ver : HttpVersion.HTTP_1_1;
            if (this.reasonPhrase != null) {
                string = this.reasonPhrase;
            } else {
                BasicHttpResponse basicHttpResponse = this;
                string = basicHttpResponse.getReason(basicHttpResponse.code);
            }
            this.statusline = new BasicStatusLine(protocolVersion, this.code, string);
        }
        return this.statusline;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatusLine(StatusLine statusline) {
        void var1_1;
        this.statusline = Args.notNull(statusline, "Status line");
        this.ver = statusline.getProtocolVersion();
        this.code = statusline.getStatusCode();
        this.reasonPhrase = var1_1.getReasonPhrase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatusLine(ProtocolVersion ver, int code) {
        void var2_2;
        void var1_1;
        Args.notNegative(code, "Status code");
        this.statusline = null;
        this.ver = var1_1;
        this.code = var2_2;
        this.reasonPhrase = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNegative(code, "Status code");
        this.statusline = null;
        this.ver = var1_1;
        this.code = var2_2;
        this.reasonPhrase = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatusCode(int code) {
        void var1_1;
        Args.notNegative(code, "Status code");
        this.statusline = null;
        this.code = var1_1;
        this.reasonPhrase = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReasonPhrase(String reason) {
        void var1_1;
        this.statusline = null;
        this.reasonPhrase = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEntity(HttpEntity entity) {
        void var1_1;
        this.entity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLocale(Locale locale) {
        void var1_1;
        this.locale = (Locale)Args.notNull(var1_1, "Locale");
        this.statusline = null;
    }

    /*
     * WARNING - void declaration
     */
    protected String getReason(int code) {
        if (this.reasonCatalog != null) {
            void var1_1;
            return this.reasonCatalog.getReason((int)var1_1, this.locale != null ? this.locale : Locale.getDefault());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatusLine());
        sb.append(' ');
        sb.append(this.headergroup);
        if (this.entity != null) {
            sb.append(' ');
            sb.append(this.entity);
        }
        return var1_1.toString();
    }
}

