/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.ArrayList;
import java.util.BitSet;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicHeaderValueParser
implements HeaderValueParser {
    @Deprecated
    public static final BasicHeaderValueParser DEFAULT = new BasicHeaderValueParser();
    public static final BasicHeaderValueParser INSTANCE = new BasicHeaderValueParser();
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59, 44);
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59, 44);
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public static HeaderElement[] parseElements(String value, HeaderValueParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseElements((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HeaderElement[] parseElements(CharArrayBuffer buffer, ParserCursor cursor) {
        void var3_3;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        while (!cursor.atEnd()) {
            HeaderElement element = this.parseHeaderElement(buffer, cursor);
            if (element.getName().length() == 0 && element.getValue() == null) continue;
            elements.add(element);
        }
        void v0 = var3_3;
        return v0.toArray(new HeaderElement[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public static HeaderElement parseHeaderElement(String value, HeaderValueParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseHeaderElement((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HeaderElement parseHeaderElement(CharArrayBuffer buffer, ParserCursor cursor) {
        void var3_3;
        char c;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        NameValuePair[] params = null;
        if (!cursor.atEnd() && (c = buffer.charAt(cursor.getPos() - 1)) != ',') {
            void var2_2;
            void var1_1;
            params = this.parseParameters((CharArrayBuffer)var1_1, (ParserCursor)var2_2);
        }
        return this.createHeaderElement(nvp.getName(), var3_3.getValue(), params);
    }

    /*
     * WARNING - void declaration
     */
    protected HeaderElement createHeaderElement(String name, String value, NameValuePair[] params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BasicHeaderElement((String)var1_1, (String)var2_2, (NameValuePair[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static NameValuePair[] parseParameters(String value, HeaderValueParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseParameters((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NameValuePair[] parseParameters(CharArrayBuffer buffer, ParserCursor cursor) {
        void var3_3;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        this.tokenParser.skipWhiteSpace(buffer, cursor);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params.add(param);
            char c = buffer.charAt(cursor.getPos() - 1);
            if (c != ',') continue;
        }
        void v0 = var3_3;
        return v0.toArray(new NameValuePair[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public static NameValuePair parseNameValuePair(String value, HeaderValueParser parser) throws ParseException {
        ParserCursor parserCursor;
        void var2_2;
        void var1_1;
        Args.notNull(value, "Value");
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? var1_1 : INSTANCE).parseNameValuePair((CharArrayBuffer)var2_2, parserCursor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        void var1_1;
        void var3_3;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String name = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (cursor.atEnd()) {
            return new BasicNameValuePair(name, null);
        }
        char delim = buffer.charAt(cursor.getPos());
        ParserCursor parserCursor = cursor;
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (delim != '=') {
            return this.createNameValuePair(name, null);
        }
        String value = this.tokenParser.parseValue(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            void var2_2;
            void v1 = var2_2;
            v1.updatePos(v1.getPos() + 1);
        }
        return this.createNameValuePair((String)var3_3, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor, char[] delimiters) {
        void var3_3;
        void var1_1;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        BitSet delimSet = new BitSet();
        if (delimiters != null) {
            char[] arr$ = delimiters;
            int len$ = delimiters.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char delimiter = arr$[i$];
                delimSet.set(delimiter);
            }
        }
        delimSet.set(61);
        String name = this.tokenParser.parseToken(buffer, cursor, delimSet);
        if (cursor.atEnd()) {
            return new BasicNameValuePair(name, null);
        }
        char delim = buffer.charAt(cursor.getPos());
        ParserCursor parserCursor = cursor;
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (delim != '=') {
            return this.createNameValuePair(name, null);
        }
        delimSet.clear(61);
        String value = this.tokenParser.parseValue((CharArrayBuffer)var1_1, cursor, delimSet);
        if (!cursor.atEnd()) {
            void var2_2;
            void v1 = var2_2;
            v1.updatePos(v1.getPos() + 1);
        }
        return this.createNameValuePair((String)var3_3, value);
    }

    /*
     * WARNING - void declaration
     */
    protected NameValuePair createNameValuePair(String name, String value) {
        void var2_2;
        void var1_1;
        return new BasicNameValuePair((String)var1_1, (String)var2_2);
    }
}

