/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    @Deprecated
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    /*
     * WARNING - void declaration
     */
    public static String formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter) {
        void var1_1;
        HeaderElement[] headerElementArray;
        void var2_2;
        return (formatter != null ? var2_2 : INSTANCE).formatElements(null, headerElementArray, (boolean)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatElements(CharArrayBuffer charBuffer, HeaderElement[] elems, boolean quote) {
        void var1_1;
        Args.notNull(elems, "Header element array");
        int len = this.estimateElementsLen(elems);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i], quote);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int estimateElementsLen(HeaderElement[] elems) {
        void var2_2;
        if (elems == null || elems.length <= 0) {
            return 0;
        }
        int result = elems.length - 1 << 1;
        HeaderElement[] arr$ = elems;
        int len$ = elems.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HeaderElement elem = arr$[i$];
            result += this.estimateHeaderElementLen(elem);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatHeaderElement(HeaderElement elem, boolean quote, HeaderValueFormatter formatter) {
        void var1_1;
        HeaderElement headerElement;
        void var2_2;
        return (formatter != null ? var2_2 : INSTANCE).formatHeaderElement(null, headerElement, (boolean)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charBuffer, HeaderElement elem, boolean quote) {
        void var1_1;
        int parcnt;
        Args.notNull(elem, "Header element");
        int len = this.estimateHeaderElementLen(elem);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i), quote);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int estimateHeaderElementLen(HeaderElement elem) {
        void var2_2;
        int parcnt;
        if (elem == null) {
            return 0;
        }
        int result = elem.getName().length();
        String value = elem.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result += 2 + this.estimateNameValuePairLen(elem.getParameter(i));
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter) {
        void var1_1;
        NameValuePair[] nameValuePairArray;
        void var2_2;
        return (formatter != null ? var2_2 : INSTANCE).formatParameters(null, nameValuePairArray, (boolean)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatParameters(CharArrayBuffer charBuffer, NameValuePair[] nvps, boolean quote) {
        void var1_1;
        Args.notNull(nvps, "Header parameter array");
        int len = this.estimateParametersLen(nvps);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i], quote);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int estimateParametersLen(NameValuePair[] nvps) {
        void var2_2;
        if (nvps == null || nvps.length <= 0) {
            return 0;
        }
        int result = nvps.length - 1 << 1;
        NameValuePair[] arr$ = nvps;
        int len$ = nvps.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair nvp = arr$[i$];
            result += this.estimateNameValuePairLen(nvp);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter) {
        void var1_1;
        NameValuePair nameValuePair;
        void var2_2;
        return (formatter != null ? var2_2 : INSTANCE).formatNameValuePair(null, nameValuePair, (boolean)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charBuffer, NameValuePair nvp, boolean quote) {
        void var1_1;
        Args.notNull(nvp, "Name / value pair");
        int len = this.estimateNameValuePairLen(nvp);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            void var3_3;
            void var2_2;
            buffer.append('=');
            this.doFormatValue(buffer, (String)var2_2, (boolean)var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int estimateNameValuePairLen(NameValuePair nvp) {
        void var2_2;
        if (nvp == null) {
            return 0;
        }
        int result = nvp.getName().length();
        String value = nvp.getValue();
        if (value != null) {
            void var1_1;
            result += 3 + var1_1.length();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFormatValue(CharArrayBuffer buffer, String value, boolean quote) {
        void var3_3;
        int i;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i = 0; i < value.length() && !quoteFlag; ++i) {
                quoteFlag = this.isSeparator(value.charAt(i));
            }
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
        for (i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (var3_3 != false) {
            void var1_1;
            var1_1.append('\"');
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSeparator(char ch) {
        void var1_1;
        return SEPARATORS.indexOf((int)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isUnsafe(char ch) {
        void var1_1;
        return UNSAFE_CHARS.indexOf((int)var1_1) >= 0;
    }
}

