/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicHeaderIterator
implements HeaderIterator {
    protected final Header[] allHeaders;
    protected int currentIndex;
    protected String headerName;

    /*
     * WARNING - void declaration
     */
    public BasicHeaderIterator(Header[] headers, String name) {
        void var2_2;
        void var1_1;
        this.allHeaders = (Header[])Args.notNull(var1_1, "Header array");
        this.headerName = var2_2;
        this.currentIndex = this.findNext(-1);
    }

    /*
     * WARNING - void declaration
     */
    protected int findNext(int pos) {
        void var3_3;
        int from = pos;
        if (from < -1) {
            return -1;
        }
        int to = this.allHeaders.length - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filterHeader(++from);
        }
        if (var3_3 != false) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean filterHeader(int index) {
        void var1_1;
        return this.headerName == null || this.headerName.equalsIgnoreCase(this.allHeaders[var1_1].getName());
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header nextHeader() throws NoSuchElementException {
        void var1_1;
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(current);
        return this.allHeaders[var1_1];
    }

    @Override
    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing headers is not supported.");
    }
}

