/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.HeaderIterator;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class BasicHeaderElementIterator
implements HeaderElementIterator {
    private final HeaderIterator headerIt;
    private final HeaderValueParser parser;
    private HeaderElement currentElement = null;
    private CharArrayBuffer buffer = null;
    private ParserCursor cursor = null;

    /*
     * WARNING - void declaration
     */
    public BasicHeaderElementIterator(HeaderIterator headerIterator, HeaderValueParser parser) {
        void var2_2;
        void var1_1;
        this.headerIt = (HeaderIterator)Args.notNull(var1_1, "Header iterator");
        this.parser = (HeaderValueParser)Args.notNull(var2_2, "Parser");
    }

    /*
     * WARNING - void declaration
     */
    public BasicHeaderElementIterator(HeaderIterator headerIterator) {
        this((HeaderIterator)var1_1, BasicHeaderValueParser.INSTANCE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void bufferHeaderValue() {
        this.cursor = null;
        this.buffer = null;
        while (this.headerIt.hasNext()) {
            void var1_1;
            Header h = this.headerIt.nextHeader();
            if (h instanceof FormattedHeader) {
                this.buffer = ((FormattedHeader)h).getBuffer();
                this.cursor = new ParserCursor(0, this.buffer.length());
                this.cursor.updatePos(((FormattedHeader)h).getValuePos());
                return;
            }
            String value = h.getValue();
            if (value == null) continue;
            this.buffer = new CharArrayBuffer(value.length());
            this.buffer.append((String)var1_1);
            this.cursor = new ParserCursor(0, this.buffer.length());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseNextElement() {
        while (this.headerIt.hasNext() || this.cursor != null) {
            if (this.cursor == null || this.cursor.atEnd()) {
                this.bufferHeaderValue();
            }
            if (this.cursor == null) continue;
            while (!this.cursor.atEnd()) {
                void var1_1;
                HeaderElement e = this.parser.parseHeaderElement(this.buffer, this.cursor);
                if (e.getName().length() == 0 && e.getValue() == null) continue;
                this.currentElement = var1_1;
                return;
            }
            if (!this.cursor.atEnd()) continue;
            this.cursor = null;
            this.buffer = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        return this.currentElement != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HeaderElement nextElement() throws NoSuchElementException {
        void var1_1;
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        if (this.currentElement == null) {
            throw new NoSuchElementException("No more header elements available");
        }
        HeaderElement element = this.currentElement;
        this.currentElement = null;
        return var1_1;
    }

    @Override
    public final Object next() throws NoSuchElementException {
        return this.nextElement();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

