/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@NotThreadSafe
public class BasicHeaderElement
implements Cloneable,
HeaderElement {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    /*
     * WARNING - void declaration
     */
    public BasicHeaderElement(String name, String value, NameValuePair[] parameters) {
        void var2_2;
        void var1_1;
        this.name = (String)Args.notNull(var1_1, "Name");
        this.value = var2_2;
        if (parameters != null) {
            void var3_3;
            this.parameters = var3_3;
            return;
        }
        this.parameters = new NameValuePair[0];
    }

    /*
     * WARNING - void declaration
     */
    public BasicHeaderElement(String name, String value) {
        this((String)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NameValuePair getParameter(int index) {
        void var1_1;
        return this.parameters[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NameValuePair getParameterByName(String name) {
        void var2_2;
        Args.notNull(name, "Name");
        NameValuePair found = null;
        NameValuePair[] arr$ = this.parameters;
        int len$ = this.parameters.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair current = arr$[i$];
            if (!current.getName().equalsIgnoreCase(name)) continue;
            found = current;
            break;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            void var1_1;
            BasicHeaderElement that = (BasicHeaderElement)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value) && LangUtils.equals(this.parameters, var1_1.parameters);
        }
        return false;
    }

    public int hashCode() {
        int n = LangUtils.hashCode(17, this.name);
        int hash = LangUtils.hashCode(n, this.value);
        NameValuePair[] arr$ = this.parameters;
        int len$ = this.parameters.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair parameter = arr$[i$];
            hash = LangUtils.hashCode(hash, parameter);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        if (this.value != null) {
            buffer.append("=");
            buffer.append(this.value);
        }
        NameValuePair[] arr$ = this.parameters;
        int len$ = this.parameters.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair parameter = arr$[i$];
            buffer.append("; ");
            buffer.append(parameter);
        }
        return var1_1.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

