/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class SessionOutputBufferImpl
implements BufferInfo,
SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final HttpTransportMetricsImpl metrics;
    private final ByteArrayBuffer buffer;
    private final int fragementSizeHint;
    private final CharsetEncoder encoder;
    private OutputStream outstream;
    private ByteBuffer bbuf;

    /*
     * WARNING - void declaration
     */
    public SessionOutputBufferImpl(HttpTransportMetricsImpl metrics, int buffersize, int fragementSizeHint, CharsetEncoder charencoder) {
        int n;
        void var2_2;
        void var1_1;
        Args.positive(buffersize, "Buffer size");
        Args.notNull(metrics, "HTTP transport metrcis");
        this.metrics = var1_1;
        this.buffer = new ByteArrayBuffer((int)var2_2);
        this.fragementSizeHint = fragementSizeHint >= 0 ? n : 0;
        this.encoder = charencoder;
    }

    /*
     * WARNING - void declaration
     */
    public SessionOutputBufferImpl(HttpTransportMetricsImpl metrics, int buffersize) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((HttpTransportMetricsImpl)var1_1, (int)v0, (int)v0, null);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(OutputStream outstream) {
        void var1_1;
        this.outstream = var1_1;
    }

    public boolean isBound() {
        return this.outstream != null;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    /*
     * WARNING - void declaration
     */
    private void streamWrite(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Asserts.notNull(this.outstream, "Output stream");
        this.outstream.write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    private void flushStream() throws IOException {
        if (this.outstream != null) {
            this.outstream.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flushBuffer() throws IOException {
        int len = this.buffer.length();
        if (len > 0) {
            void var1_1;
            SessionOutputBufferImpl sessionOutputBufferImpl = this;
            sessionOutputBufferImpl.streamWrite(sessionOutputBufferImpl.buffer.buffer(), 0, len);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred((long)var1_1);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.flushStream();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        if (len > this.fragementSizeHint || len > this.buffer.capacity()) {
            this.flushBuffer();
            this.streamWrite(b, off, len);
            this.metrics.incrementBytesTransferred(len);
            return;
        }
        int freecapacity = this.buffer.capacity() - this.buffer.length();
        if (len > freecapacity) {
            this.flushBuffer();
        }
        this.buffer.append((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b) throws IOException {
        void var1_1;
        if (b == null) {
            return;
        }
        this.write(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        void var1_1;
        if (this.fragementSizeHint > 0) {
            if (this.buffer.isFull()) {
                this.flushBuffer();
            }
            this.buffer.append(b);
            return;
        }
        this.flushBuffer();
        this.outstream.write((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLine(String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() > 0) {
            if (this.encoder == null) {
                for (int i = 0; i < s.length(); ++i) {
                    this.write(s.charAt(i));
                }
            } else {
                void var2_3;
                void var1_1;
                CharBuffer cbuf = CharBuffer.wrap((CharSequence)var1_1);
                this.writeEncoded((CharBuffer)var2_3);
            }
        }
        this.write(CRLF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLine(CharArrayBuffer charbuffer) throws IOException {
        if (charbuffer == null) {
            return;
        }
        if (this.encoder == null) {
            int chunk;
            int off = 0;
            for (int remaining = charbuffer.length(); remaining > 0; remaining -= chunk) {
                int n = this.buffer.capacity() - this.buffer.length();
                chunk = Math.min(n, remaining);
                if (chunk > 0) {
                    this.buffer.append(charbuffer, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            void var2_3;
            void var1_1;
            CharBuffer cbuf = CharBuffer.wrap(charbuffer.buffer(), 0, var1_1.length());
            this.writeEncoded((CharBuffer)var2_3);
        }
        this.write(CRLF);
    }

    /*
     * WARNING - void declaration
     */
    private void writeEncoded(CharBuffer cbuf) throws IOException {
        void var2_2;
        CoderResult result;
        if (!cbuf.hasRemaining()) {
            return;
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (cbuf.hasRemaining()) {
            result = this.encoder.encode(cbuf, this.bbuf, true);
            this.handleEncodingResult(result);
        }
        result = this.encoder.flush(this.bbuf);
        this.handleEncodingResult((CoderResult)var2_2);
        this.bbuf.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void handleEncodingResult(CoderResult result) throws IOException {
        if (result.isError()) {
            void var1_1;
            var1_1.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            SessionOutputBufferImpl sessionOutputBufferImpl = this;
            sessionOutputBufferImpl.write(sessionOutputBufferImpl.bbuf.get());
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

