/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.http.MessageConstraintException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class SessionInputBufferImpl
implements BufferInfo,
SessionInputBuffer {
    private final HttpTransportMetricsImpl metrics;
    private final byte[] buffer;
    private final ByteArrayBuffer linebuffer;
    private final int minChunkLimit;
    private final MessageConstraints constraints;
    private final CharsetDecoder decoder;
    private InputStream instream;
    private int bufferpos;
    private int bufferlen;
    private CharBuffer cbuf;

    /*
     * WARNING - void declaration
     */
    public SessionInputBufferImpl(HttpTransportMetricsImpl metrics, int buffersize, int minChunkLimit, MessageConstraints constraints, CharsetDecoder chardecoder) {
        void var2_2;
        int n;
        void var1_1;
        Args.notNull(metrics, "HTTP transport metrcis");
        Args.positive(buffersize, "Buffer size");
        this.metrics = var1_1;
        this.buffer = new byte[buffersize];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.minChunkLimit = minChunkLimit >= 0 ? n : 512;
        this.constraints = constraints != null ? constraints : MessageConstraints.DEFAULT;
        this.linebuffer = new ByteArrayBuffer((int)var2_2);
        this.decoder = chardecoder;
    }

    /*
     * WARNING - void declaration
     */
    public SessionInputBufferImpl(HttpTransportMetricsImpl metrics, int buffersize) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((HttpTransportMetricsImpl)var1_1, (int)v0, (int)v0, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(InputStream instream) {
        void var1_1;
        this.instream = var1_1;
    }

    public boolean isBound() {
        return this.instream != null;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferlen - this.bufferpos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    /*
     * WARNING - void declaration
     */
    private int streamRead(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Asserts.notNull(this.instream, "Input stream");
        return this.instream.read((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public int fillBuffer() throws IOException {
        void var1_1;
        void var2_2;
        int len;
        if (this.bufferpos > 0) {
            len = this.bufferlen - this.bufferpos;
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, len);
            }
            this.bufferpos = 0;
            this.bufferlen = len;
        }
        int off = this.bufferlen;
        len = this.buffer.length - off;
        SessionInputBufferImpl sessionInputBufferImpl = this;
        int l = sessionInputBufferImpl.streamRead(sessionInputBufferImpl.buffer, off, len);
        if (l == -1) {
            return -1;
        }
        this.bufferlen = var2_2 + l;
        this.metrics.incrementBytesTransferred(l);
        return (int)var1_1;
    }

    public boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    public void clear() {
        this.bufferpos = 0;
        this.bufferlen = 0;
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBufferedData()) {
            int n = this.fillBuffer();
            if (n != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (b == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int chunk = Math.min(len, this.bufferlen - this.bufferpos);
            System.arraycopy(this.buffer, this.bufferpos, b, off, chunk);
            this.bufferpos += chunk;
            return chunk;
        }
        if (len > this.minChunkLimit) {
            int read = this.streamRead(b, off, len);
            if (read > 0) {
                this.metrics.incrementBytesTransferred(read);
            }
            return read;
        }
        while (!this.hasBufferedData()) {
            int read = this.fillBuffer();
            if (read != -1) continue;
            return -1;
        }
        int chunk = Math.min((int)var3_3, this.bufferlen - this.bufferpos);
        System.arraycopy(this.buffer, this.bufferpos, var1_1, (int)var2_2, chunk);
        this.bufferpos += chunk;
        return chunk;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        void var1_1;
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readLine(CharArrayBuffer charbuffer) throws IOException {
        void var1_1;
        void var3_3;
        Args.notNull(charbuffer, "Char array buffer");
        int maxLineLen = this.constraints.getMaxLineLength();
        int noRead = 0;
        boolean retry = true;
        while (retry) {
            int len;
            int i;
            int pos = -1;
            for (i = this.bufferpos; i < this.bufferlen; ++i) {
                if (this.buffer[i] != 10) continue;
                pos = i;
                break;
            }
            if (maxLineLen > 0 && (i = this.linebuffer.length() + (pos > 0 ? pos : this.bufferlen) - this.bufferpos) >= maxLineLen) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            if (pos != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charbuffer, pos);
                }
                retry = false;
                len = pos + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, len);
                this.bufferpos = pos + 1;
                continue;
            }
            if (this.hasBufferedData()) {
                len = this.bufferlen - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, len);
                this.bufferpos = this.bufferlen;
            }
            if ((noRead = this.fillBuffer()) != -1) continue;
            retry = false;
        }
        if (var3_3 == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer((CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int lineFromLineBuffer(CharArrayBuffer charbuffer) throws IOException {
        int n;
        int len = this.linebuffer.length();
        if (len > 0) {
            if (this.linebuffer.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && this.linebuffer.byteAt(len - 1) == 13) {
                --len;
            }
        }
        if (this.decoder == null) {
            charbuffer.append(this.linebuffer, 0, len);
        } else {
            void var2_3;
            void var1_1;
            ByteBuffer bbuf = ByteBuffer.wrap(this.linebuffer.buffer(), 0, len);
            n = this.appendDecoded((CharArrayBuffer)var1_1, (ByteBuffer)var2_3);
        }
        this.linebuffer.clear();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int lineFromReadBuffer(CharArrayBuffer charbuffer, int position) throws IOException {
        int n;
        int pos = position;
        int off = this.bufferpos;
        this.bufferpos = pos + 1;
        if (pos > off && this.buffer[pos - 1] == 13) {
            --pos;
        }
        int len = pos - off;
        if (this.decoder == null) {
            charbuffer.append(this.buffer, off, len);
        } else {
            void var2_3;
            void var1_1;
            void var3_4;
            ByteBuffer bbuf = ByteBuffer.wrap(this.buffer, (int)var3_4, len);
            n = this.appendDecoded((CharArrayBuffer)var1_1, (ByteBuffer)var2_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int appendDecoded(CharArrayBuffer charbuffer, ByteBuffer bbuf) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        CoderResult result;
        if (!bbuf.hasRemaining()) {
            return 0;
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int len = 0;
        while (bbuf.hasRemaining()) {
            result = this.decoder.decode(bbuf, this.cbuf, true);
            len += this.handleDecodingResult(result, charbuffer, bbuf);
        }
        result = this.decoder.flush(this.cbuf);
        len += this.handleDecodingResult(result, (CharArrayBuffer)var1_1, (ByteBuffer)var2_2);
        this.cbuf.clear();
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleDecodingResult(CoderResult result, CharArrayBuffer charbuffer, ByteBuffer bbuf) throws IOException {
        void var1_2;
        if (result.isError()) {
            result.throwException();
        }
        this.cbuf.flip();
        int len = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charbuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String readLine() throws IOException {
        CharArrayBuffer charbuffer = new CharArrayBuffer(64);
        int n = this.readLine(charbuffer);
        if (n != -1) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    @Override
    public boolean isDataAvailable(int timeout) throws IOException {
        return this.hasBufferedData();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

