/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;

@NotThreadSafe
public class ContentLengthOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private final long contentLength;
    private long total = 0L;
    private boolean closed = false;

    /*
     * WARNING - void declaration
     */
    public ContentLengthOutputStream(SessionOutputBuffer out, long contentLength) {
        void var2_2;
        void var1_1;
        this.out = (SessionOutputBuffer)Args.notNull(var1_1, "Session output buffer");
        this.contentLength = Args.notNegative((long)var2_2, "Content length");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            int chunk = len;
            long max = this.contentLength - this.total;
            if ((long)chunk > max) {
                chunk = (int)max;
            }
            this.out.write((byte[])var1_1, (int)var2_2, chunk);
            this.total += (long)var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b) throws IOException {
        void var1_1;
        this.write(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            void var1_1;
            this.out.write((int)var1_1);
            ++this.total;
        }
    }
}

