/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.ConnectionClosedException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;

@NotThreadSafe
public class ContentLengthInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private final long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private SessionInputBuffer in = null;

    /*
     * WARNING - void declaration
     */
    public ContentLengthInputStream(SessionInputBuffer in, long contentLength) {
        void var2_2;
        void var1_1;
        this.in = (SessionInputBuffer)Args.notNull(var1_1, "Session input buffer");
        this.contentLength = Args.notNegative((long)var2_2, "Content length");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.pos < this.contentLength) {
                    byte[] buffer = new byte[2048];
                    while (this.read(buffer) >= 0) {
                    }
                }
                return;
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            int n = ((BufferInfo)((Object)this.in)).length();
            return Math.min(n, (int)(this.contentLength - this.pos));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        void var1_1;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int b = this.in.read();
        if (b == -1) {
            if (this.pos < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: " + this.contentLength + "; received: " + this.pos);
            }
        } else {
            ++this.pos;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var1_2;
        void var2_3;
        int count;
        void var3_4;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int chunk = len;
        if (this.pos + (long)var3_4 > this.contentLength) {
            chunk = (int)(this.contentLength - this.pos);
        }
        if ((count = this.in.read(b, (int)var2_3, chunk)) == -1 && this.pos < this.contentLength) {
            throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: " + this.contentLength + "; received: " + this.pos);
        }
        if (count > 0) {
            this.pos += (long)count;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        void var1_1;
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long n) throws IOException {
        int l;
        void var1_2;
        if (n <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[2048];
        long count = 0L;
        for (long remaining = Math.min(n, this.contentLength - this.pos); remaining > 0L && (l = this.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1; remaining -= (long)var1_2) {
            count += (long)l;
        }
        return count;
    }
}

