/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.SessionOutputBuffer;

@NotThreadSafe
public class ChunkedOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private final byte[] cache;
    private int cachePosition = 0;
    private boolean wroteLastChunk = false;
    private boolean closed = false;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ChunkedOutputStream(SessionOutputBuffer out, int bufferSize) throws IOException {
        this((int)var2_2, (SessionOutputBuffer)var1_1);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ChunkedOutputStream(SessionOutputBuffer out) throws IOException {
        this(2048, (SessionOutputBuffer)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedOutputStream(int bufferSize, SessionOutputBuffer out) {
        void var2_2;
        void var1_1;
        this.cache = new byte[var1_1];
        this.out = var2_2;
    }

    protected void flushCache() throws IOException {
        if (this.cachePosition > 0) {
            this.out.writeLine(Integer.toHexString(this.cachePosition));
            this.out.write(this.cache, 0, this.cachePosition);
            this.out.writeLine("");
            this.cachePosition = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void flushCacheWithAppend(byte[] bufferToAppend, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.out.writeLine(Integer.toHexString(this.cachePosition + len));
        this.out.write(this.cache, 0, this.cachePosition);
        this.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        this.out.writeLine("");
        this.cachePosition = 0;
    }

    protected void writeClosingChunk() throws IOException {
        this.out.writeLine("0");
        this.out.writeLine("");
    }

    public void finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        void var1_1;
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.cache[this.cachePosition] = (byte)var1_1;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b) throws IOException {
        void var1_1;
        this.write(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] src, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (len >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(src, off, len);
            return;
        }
        System.arraycopy(var1_1, (int)var2_2, this.cache, this.cachePosition, len);
        this.cachePosition += var3_3;
    }

    @Override
    public void flush() throws IOException {
        this.flushCache();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.finish();
            this.out.flush();
        }
    }
}

