/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.TruncatedChunkException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class ChunkedInputStream
extends InputStream {
    private static final int CHUNK_LEN = 1;
    private static final int CHUNK_DATA = 2;
    private static final int CHUNK_CRLF = 3;
    private static final int CHUNK_INVALID = Integer.MAX_VALUE;
    private static final int BUFFER_SIZE = 2048;
    private final SessionInputBuffer in;
    private final CharArrayBuffer buffer;
    private final MessageConstraints constraints;
    private int state;
    private int chunkSize;
    private int pos;
    private boolean eof = false;
    private boolean closed = false;
    private Header[] footers = new Header[0];

    /*
     * WARNING - void declaration
     */
    public ChunkedInputStream(SessionInputBuffer in, MessageConstraints constraints) {
        void var2_2;
        void var1_1;
        this.in = (SessionInputBuffer)Args.notNull(var1_1, "Session input buffer");
        this.pos = 0;
        this.buffer = new CharArrayBuffer(16);
        this.constraints = constraints != null ? var2_2 : MessageConstraints.DEFAULT;
        this.state = 1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedInputStream(SessionInputBuffer in) {
        this((SessionInputBuffer)var1_1, null);
        void var1_1;
    }

    @Override
    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            int n = ((BufferInfo)((Object)this.in)).length();
            return Math.min(n, this.chunkSize - this.pos);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        void var1_1;
        int b;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((b = this.in.read()) != -1) {
            ++this.pos;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var3_4;
        void var2_3;
        int bytesRead;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((bytesRead = this.in.read(b, (int)var2_3, Math.min((int)var3_4, this.chunkSize - this.pos))) != -1) {
            void var1_2;
            this.pos += bytesRead;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
            return (int)var1_2;
        }
        this.eof = true;
        throw new TruncatedChunkException("Truncated chunk ( expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        void var1_1;
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    private void nextChunk() throws IOException {
        if (this.state == Integer.MAX_VALUE) {
            throw new MalformedChunkCodingException("Corrupt data stream");
        }
        try {
            this.chunkSize = this.getChunkSize();
            if (this.chunkSize < 0) {
                throw new MalformedChunkCodingException("Negative chunk size");
            }
            this.state = 2;
            this.pos = 0;
            if (this.chunkSize == 0) {
                this.eof = true;
                this.parseTrailerHeaders();
            }
            return;
        }
        catch (MalformedChunkCodingException ex) {
            void var1_1;
            this.state = Integer.MAX_VALUE;
            throw var1_1;
        }
    }

    private int getChunkSize() throws IOException {
        int n = this.state;
        switch (n) {
            case 3: {
                this.buffer.clear();
                n = this.in.readLine(this.buffer);
                if (n == -1) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                if (!this.buffer.isEmpty()) {
                    throw new MalformedChunkCodingException("Unexpected content at the end of chunk");
                }
                this.state = 1;
            }
            case 1: {
                this.buffer.clear();
                n = this.in.readLine(this.buffer);
                if (n == -1) {
                    throw new ConnectionClosedException("Premature end of chunk coded message body: closing chunk expected");
                }
                int separator = this.buffer.indexOf(59);
                if (separator < 0) {
                    separator = this.buffer.length();
                }
                try {
                    return Integer.parseInt(this.buffer.substringTrimmed(0, n), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedChunkCodingException("Bad chunk header");
                }
            }
        }
        throw new IllegalStateException("Inconsistent codec state");
    }

    /*
     * WARNING - void declaration
     */
    private void parseTrailerHeaders() throws IOException {
        try {
            this.footers = AbstractMessageParser.parseHeaders(this.in, this.constraints.getMaxHeaderCount(), this.constraints.getMaxLineLength(), null);
            return;
        }
        catch (HttpException ex) {
            void var2_2;
            void var1_1;
            MalformedChunkCodingException ioe = new MalformedChunkCodingException("Invalid footer: " + ex.getMessage());
            ioe.initCause((Throwable)var1_1);
            throw var2_2;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof && this.state != Integer.MAX_VALUE) {
                    byte[] buff = new byte[2048];
                    while (this.read(buff) >= 0) {
                    }
                }
                return;
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    public Header[] getFooters() {
        return (Header[])this.footers.clone();
    }
}

