/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@Deprecated
@NotThreadSafe
public abstract class AbstractSessionOutputBuffer
implements BufferInfo,
SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private Charset charset;
    private boolean ascii;
    private int minChunkLimit;
    private HttpTransportMetricsImpl metrics;
    private CodingErrorAction onMalformedCharAction;
    private CodingErrorAction onUnmappableCharAction;
    private CharsetEncoder encoder;
    private ByteBuffer bbuf;

    /*
     * WARNING - void declaration
     */
    protected AbstractSessionOutputBuffer(OutputStream outstream, int buffersize, Charset charset, int minChunkLimit, CodingErrorAction malformedCharAction, CodingErrorAction unmappableCharAction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull(outstream, "Input stream");
        Args.notNegative(buffersize, "Buffer size");
        this.outstream = var1_1;
        this.buffer = new ByteArrayBuffer((int)var2_2);
        this.charset = charset != null ? var3_3 : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.encoder = null;
        this.minChunkLimit = minChunkLimit >= 0 ? minChunkLimit : 512;
        this.metrics = this.createTransportMetrics();
        this.onMalformedCharAction = malformedCharAction != null ? malformedCharAction : CodingErrorAction.REPORT;
        this.onUnmappableCharAction = unmappableCharAction != null ? unmappableCharAction : CodingErrorAction.REPORT;
    }

    public AbstractSessionOutputBuffer() {
    }

    /*
     * WARNING - void declaration
     */
    protected void init(OutputStream outstream, int buffersize, HttpParams params) {
        void var1_1;
        void var3_3;
        void var2_2;
        Args.notNull(outstream, "Input stream");
        Args.notNegative(buffersize, "Buffer size");
        Args.notNull(params, "HTTP parameters");
        this.outstream = outstream;
        this.buffer = new ByteArrayBuffer((int)var2_2);
        String charset = (String)params.getParameter("http.protocol.element-charset");
        this.charset = charset != null ? Charset.forName(charset) : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.encoder = null;
        this.minChunkLimit = params.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
        CodingErrorAction a1 = (CodingErrorAction)params.getParameter("http.malformed.input.action");
        this.onMalformedCharAction = a1 != null ? a1 : CodingErrorAction.REPORT;
        CodingErrorAction a2 = (CodingErrorAction)var3_3.getParameter("http.unmappable.input.action");
        this.onUnmappableCharAction = a2 != null ? var1_1 : CodingErrorAction.REPORT;
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    /*
     * WARNING - void declaration
     */
    protected void flushBuffer() throws IOException {
        int len = this.buffer.length();
        if (len > 0) {
            void var1_1;
            this.outstream.write(this.buffer.buffer(), 0, len);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred((long)var1_1);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        if (len > this.minChunkLimit || len > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(b, off, len);
            this.metrics.incrementBytesTransferred(len);
            return;
        }
        int freecapacity = this.buffer.capacity() - this.buffer.length();
        if (len > freecapacity) {
            this.flushBuffer();
        }
        this.buffer.append((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b) throws IOException {
        void var1_1;
        if (b == null) {
            return;
        }
        this.write(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        void var1_1;
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLine(String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() > 0) {
            if (this.ascii) {
                for (int i = 0; i < s.length(); ++i) {
                    this.write(s.charAt(i));
                }
            } else {
                void var2_3;
                void var1_1;
                CharBuffer cbuf = CharBuffer.wrap((CharSequence)var1_1);
                this.writeEncoded((CharBuffer)var2_3);
            }
        }
        this.write(CRLF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLine(CharArrayBuffer charbuffer) throws IOException {
        if (charbuffer == null) {
            return;
        }
        if (this.ascii) {
            int chunk;
            int off = 0;
            for (int remaining = charbuffer.length(); remaining > 0; remaining -= chunk) {
                int n = this.buffer.capacity() - this.buffer.length();
                chunk = Math.min(n, remaining);
                if (chunk > 0) {
                    this.buffer.append(charbuffer, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            void var2_3;
            void var1_1;
            CharBuffer cbuf = CharBuffer.wrap(charbuffer.buffer(), 0, var1_1.length());
            this.writeEncoded((CharBuffer)var2_3);
        }
        this.write(CRLF);
    }

    /*
     * WARNING - void declaration
     */
    private void writeEncoded(CharBuffer cbuf) throws IOException {
        void var2_2;
        CoderResult result;
        if (!cbuf.hasRemaining()) {
            return;
        }
        if (this.encoder == null) {
            this.encoder = this.charset.newEncoder();
            this.encoder.onMalformedInput(this.onMalformedCharAction);
            this.encoder.onUnmappableCharacter(this.onUnmappableCharAction);
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (cbuf.hasRemaining()) {
            result = this.encoder.encode(cbuf, this.bbuf, true);
            this.handleEncodingResult(result);
        }
        result = this.encoder.flush(this.bbuf);
        this.handleEncodingResult((CoderResult)var2_2);
        this.bbuf.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void handleEncodingResult(CoderResult result) throws IOException {
        if (result.isError()) {
            void var1_1;
            var1_1.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            AbstractSessionOutputBuffer abstractSessionOutputBuffer = this;
            abstractSessionOutputBuffer.write(abstractSessionOutputBuffer.bbuf.get());
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

