/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@Deprecated
@NotThreadSafe
public abstract class AbstractSessionInputBuffer
implements BufferInfo,
SessionInputBuffer {
    private InputStream instream;
    private byte[] buffer;
    private ByteArrayBuffer linebuffer;
    private Charset charset;
    private boolean ascii;
    private int maxLineLen;
    private int minChunkLimit;
    private HttpTransportMetricsImpl metrics;
    private CodingErrorAction onMalformedCharAction;
    private CodingErrorAction onUnmappableCharAction;
    private int bufferpos;
    private int bufferlen;
    private CharsetDecoder decoder;
    private CharBuffer cbuf;

    /*
     * WARNING - void declaration
     */
    protected void init(InputStream instream, int buffersize, HttpParams params) {
        void var1_1;
        void var3_3;
        void var2_2;
        Args.notNull(instream, "Input stream");
        Args.notNegative(buffersize, "Buffer size");
        Args.notNull(params, "HTTP parameters");
        this.instream = instream;
        this.buffer = new byte[buffersize];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.linebuffer = new ByteArrayBuffer((int)var2_2);
        String charset = (String)params.getParameter("http.protocol.element-charset");
        this.charset = charset != null ? Charset.forName(charset) : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.decoder = null;
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.minChunkLimit = params.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
        CodingErrorAction a1 = (CodingErrorAction)params.getParameter("http.malformed.input.action");
        this.onMalformedCharAction = a1 != null ? a1 : CodingErrorAction.REPORT;
        CodingErrorAction a2 = (CodingErrorAction)var3_3.getParameter("http.unmappable.input.action");
        this.onUnmappableCharAction = a2 != null ? var1_1 : CodingErrorAction.REPORT;
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferlen - this.bufferpos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    /*
     * WARNING - void declaration
     */
    protected int fillBuffer() throws IOException {
        void var1_1;
        void var2_2;
        int off;
        int l;
        int len;
        if (this.bufferpos > 0) {
            len = this.bufferlen - this.bufferpos;
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, len);
            }
            this.bufferpos = 0;
            this.bufferlen = len;
        }
        if ((l = this.instream.read(this.buffer, off = this.bufferlen, len = this.buffer.length - off)) == -1) {
            return -1;
        }
        this.bufferlen = var2_2 + l;
        this.metrics.incrementBytesTransferred(l);
        return (int)var1_1;
    }

    protected boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBufferedData()) {
            int n = this.fillBuffer();
            if (n != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (b == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int chunk = Math.min(len, this.bufferlen - this.bufferpos);
            System.arraycopy(this.buffer, this.bufferpos, b, off, chunk);
            this.bufferpos += chunk;
            return chunk;
        }
        if (len > this.minChunkLimit) {
            int read = this.instream.read(b, off, len);
            if (read > 0) {
                this.metrics.incrementBytesTransferred(read);
            }
            return read;
        }
        while (!this.hasBufferedData()) {
            int read = this.fillBuffer();
            if (read != -1) continue;
            return -1;
        }
        int chunk = Math.min((int)var3_3, this.bufferlen - this.bufferpos);
        System.arraycopy(this.buffer, this.bufferpos, var1_1, (int)var2_2, chunk);
        this.bufferpos += chunk;
        return chunk;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        void var1_1;
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, ((void)var1_1).length);
    }

    private int locateLF() {
        for (int i = this.bufferpos; i < this.bufferlen; ++i) {
            if (this.buffer[i] != 10) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readLine(CharArrayBuffer charbuffer) throws IOException {
        void var1_1;
        void var2_2;
        Args.notNull(charbuffer, "Char array buffer");
        int noRead = 0;
        boolean retry = true;
        while (retry) {
            int len;
            int i = this.locateLF();
            if (i != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charbuffer, i);
                }
                retry = false;
                len = i + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, len);
                this.bufferpos = i + 1;
            } else {
                if (this.hasBufferedData()) {
                    len = this.bufferlen - this.bufferpos;
                    this.linebuffer.append(this.buffer, this.bufferpos, len);
                    this.bufferpos = this.bufferlen;
                }
                if ((noRead = this.fillBuffer()) == -1) {
                    retry = false;
                }
            }
            if (this.maxLineLen <= 0 || this.linebuffer.length() < this.maxLineLen) continue;
            throw new IOException("Maximum line length limit exceeded");
        }
        if (var2_2 == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer((CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int lineFromLineBuffer(CharArrayBuffer charbuffer) throws IOException {
        int n;
        int len = this.linebuffer.length();
        if (len > 0) {
            if (this.linebuffer.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && this.linebuffer.byteAt(len - 1) == 13) {
                --len;
            }
        }
        if (this.ascii) {
            charbuffer.append(this.linebuffer, 0, len);
        } else {
            void var2_3;
            void var1_1;
            ByteBuffer bbuf = ByteBuffer.wrap(this.linebuffer.buffer(), 0, len);
            n = this.appendDecoded((CharArrayBuffer)var1_1, (ByteBuffer)var2_3);
        }
        this.linebuffer.clear();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int lineFromReadBuffer(CharArrayBuffer charbuffer, int position) throws IOException {
        int n;
        void i;
        int off = this.bufferpos;
        this.bufferpos = i + true;
        if (i > off && this.buffer[i - true] == 13) {
            --i;
        }
        void len = i - off;
        if (this.ascii) {
            charbuffer.append(this.buffer, off, (int)len);
        } else {
            void var2_3;
            void var1_1;
            void var3_4;
            ByteBuffer bbuf = ByteBuffer.wrap(this.buffer, (int)var3_4, (int)len);
            n = this.appendDecoded((CharArrayBuffer)var1_1, (ByteBuffer)var2_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int appendDecoded(CharArrayBuffer charbuffer, ByteBuffer bbuf) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        CoderResult result;
        if (!bbuf.hasRemaining()) {
            return 0;
        }
        if (this.decoder == null) {
            this.decoder = this.charset.newDecoder();
            this.decoder.onMalformedInput(this.onMalformedCharAction);
            this.decoder.onUnmappableCharacter(this.onUnmappableCharAction);
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int len = 0;
        while (bbuf.hasRemaining()) {
            result = this.decoder.decode(bbuf, this.cbuf, true);
            len += this.handleDecodingResult(result, charbuffer, bbuf);
        }
        result = this.decoder.flush(this.cbuf);
        len += this.handleDecodingResult(result, (CharArrayBuffer)var1_1, (ByteBuffer)var2_2);
        this.cbuf.clear();
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleDecodingResult(CoderResult result, CharArrayBuffer charbuffer, ByteBuffer bbuf) throws IOException {
        void var1_2;
        if (result.isError()) {
            result.throwException();
        }
        this.cbuf.flip();
        int len = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charbuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String readLine() throws IOException {
        CharArrayBuffer charbuffer = new CharArrayBuffer(64);
        int n = this.readLine(charbuffer);
        if (n != -1) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

