/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.bootstrap;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class ServerBootstrap {
    private int listenerPort;
    private InetAddress localAddress;
    private SocketConfig socketConfig;
    private ConnectionConfig connectionConfig;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private String serverInfo;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory responseFactory;
    private HttpRequestHandlerMapper handlerMapper;
    private Map<String, HttpRequestHandler> handlerMap;
    private HttpExpectationVerifier expectationVerifier;
    private ServerSocketFactory serverSocketFactory;
    private SSLContext sslContext;
    private SSLServerSetupHandler sslSetupHandler;
    private HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private ExceptionLogger exceptionLogger;

    private ServerBootstrap() {
    }

    public static ServerBootstrap bootstrap() {
        return new ServerBootstrap();
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setListenerPort(int listenerPort) {
        void var1_1;
        this.listenerPort = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setLocalAddress(InetAddress localAddress) {
        void var1_1;
        this.localAddress = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setSocketConfig(SocketConfig socketConfig) {
        void var1_1;
        this.socketConfig = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setConnectionConfig(ConnectionConfig connectionConfig) {
        void var1_1;
        this.connectionConfig = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        void var1_1;
        this.httpProcessor = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap addInterceptorFirst(HttpResponseInterceptor itcp) {
        void var1_1;
        if (itcp == null) {
            return this;
        }
        if (this.responseFirst == null) {
            this.responseFirst = new LinkedList();
        }
        this.responseFirst.addFirst((HttpResponseInterceptor)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap addInterceptorLast(HttpResponseInterceptor itcp) {
        void var1_1;
        if (itcp == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast((HttpResponseInterceptor)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap addInterceptorFirst(HttpRequestInterceptor itcp) {
        void var1_1;
        if (itcp == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst((HttpRequestInterceptor)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap addInterceptorLast(HttpRequestInterceptor itcp) {
        void var1_1;
        if (itcp == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast((HttpRequestInterceptor)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setServerInfo(String serverInfo) {
        void var1_1;
        this.serverInfo = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connStrategy) {
        void var1_1;
        this.connStrategy = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setResponseFactory(HttpResponseFactory responseFactory) {
        void var1_1;
        this.responseFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setHandlerMapper(HttpRequestHandlerMapper handlerMapper) {
        void var1_1;
        this.handlerMapper = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap registerHandler(String pattern, HttpRequestHandler handler) {
        void var2_2;
        void var1_1;
        if (pattern == null || handler == null) {
            return this;
        }
        if (this.handlerMap == null) {
            this.handlerMap = new HashMap<String, HttpRequestHandler>();
        }
        this.handlerMap.put((String)var1_1, (HttpRequestHandler)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        void var1_1;
        this.expectationVerifier = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setConnectionFactory(HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory) {
        void var1_1;
        this.connectionFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setSslSetupHandler(SSLServerSetupHandler sslSetupHandler) {
        void var1_1;
        this.sslSetupHandler = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        void var1_1;
        this.serverSocketFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setSslContext(SSLContext sslContext) {
        void var1_1;
        this.sslContext = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ServerBootstrap setExceptionLogger(ExceptionLogger exceptionLogger) {
        void var1_1;
        this.exceptionLogger = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServer create() {
        void var3_3;
        void var2_2;
        void var1_1;
        ExceptionLogger exceptionLoggerCopy;
        DefaultBHttpServerConnectionFactory connectionFactoryCopy;
        void var4_15;
        HttpResponseFactory httpResponseFactory;
        ConnectionReuseStrategy connStrategyCopy;
        HttpRequestHandlerMapper handlerMapperCopy;
        HttpProcessor httpProcessorCopy = this.httpProcessor;
        if (httpProcessorCopy == null) {
            String serverInfoCopy;
            HttpProcessorBuilder b = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestFirst) {
                    b.addFirst(httpRequestInterceptor);
                }
            }
            if (this.responseFirst != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseFirst) {
                    b.addFirst(httpResponseInterceptor);
                }
            }
            if ((serverInfoCopy = this.serverInfo) == null) {
                serverInfoCopy = "Apache-HttpCore/1.1";
            }
            b.addAll(new ResponseDate(), new ResponseServer(serverInfoCopy), new ResponseContent(), new ResponseConnControl());
            if (this.requestLast != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestLast) {
                    b.addLast(httpRequestInterceptor);
                }
            }
            if (this.responseLast != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseLast) {
                    b.addLast(httpResponseInterceptor);
                }
            }
            httpProcessorCopy = b.build();
        }
        if ((handlerMapperCopy = this.handlerMapper) == null) {
            UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
            if (this.handlerMap != null) {
                for (Map.Entry<String, HttpRequestHandler> entry : this.handlerMap.entrySet()) {
                    reqistry.register(entry.getKey(), entry.getValue());
                }
            }
            handlerMapperCopy = reqistry;
        }
        if ((connStrategyCopy = this.connStrategy) == null) {
            connStrategyCopy = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((httpResponseFactory = this.responseFactory) == null) {
            DefaultHttpResponseFactory defaultHttpResponseFactory = DefaultHttpResponseFactory.INSTANCE;
        }
        HttpService httpService = new HttpService(httpProcessorCopy, connStrategyCopy, (HttpResponseFactory)var4_15, handlerMapperCopy, this.expectationVerifier);
        ServerSocketFactory serverSocketFactoryCopy = this.serverSocketFactory;
        if (serverSocketFactoryCopy == null) {
            serverSocketFactoryCopy = this.sslContext != null ? this.sslContext.getServerSocketFactory() : ServerSocketFactory.getDefault();
        }
        if ((connectionFactoryCopy = this.connectionFactory) == null) {
            connectionFactoryCopy = this.connectionConfig != null ? new DefaultBHttpServerConnectionFactory(this.connectionConfig) : DefaultBHttpServerConnectionFactory.INSTANCE;
        }
        if ((exceptionLoggerCopy = this.exceptionLogger) == null) {
            exceptionLoggerCopy = ExceptionLogger.NO_OP;
        }
        return new HttpServer(this.listenerPort > 0 ? this.listenerPort : 0, this.localAddress, this.socketConfig != null ? this.socketConfig : SocketConfig.DEFAULT, (ServerSocketFactory)var1_1, httpService, (HttpConnectionFactory<? extends DefaultBHttpServerConnection>)var2_2, this.sslSetupHandler, (ExceptionLogger)var3_3);
    }
}

