/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.bootstrap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.RequestListener;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ThreadFactoryImpl;
import org.apache.http.impl.bootstrap.Worker;
import org.apache.http.protocol.HttpService;

public class HttpServer {
    private final int port;
    private final InetAddress ifAddress;
    private final SocketConfig socketConfig;
    private final ServerSocketFactory serverSocketFactory;
    private final HttpService httpService;
    private final HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private final SSLServerSetupHandler sslSetupHandler;
    private final ExceptionLogger exceptionLogger;
    private final ExecutorService listenerExecutorService;
    private final ThreadGroup workerThreads;
    private final ExecutorService workerExecutorService;
    private final AtomicReference<Status> status;
    private volatile ServerSocket serverSocket;
    private volatile RequestListener requestListener;

    /*
     * WARNING - void declaration
     */
    HttpServer(int port, InetAddress ifAddress, SocketConfig socketConfig, ServerSocketFactory serverSocketFactory, HttpService httpService, HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory, SSLServerSetupHandler sslSetupHandler, ExceptionLogger exceptionLogger) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.port = var1_1;
        this.ifAddress = var2_2;
        this.socketConfig = var3_3;
        this.serverSocketFactory = serverSocketFactory;
        this.httpService = httpService;
        this.connectionFactory = connectionFactory;
        this.sslSetupHandler = sslSetupHandler;
        this.exceptionLogger = exceptionLogger;
        this.listenerExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryImpl("HTTP-listener-" + this.port));
        this.workerThreads = new ThreadGroup("HTTP-workers");
        this.workerExecutorService = Executors.newCachedThreadPool(new ThreadFactoryImpl("HTTP-worker", this.workerThreads));
        this.status = new AtomicReference<Status>(Status.READY);
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress getInetAddress() {
        ServerSocket localSocket = this.serverSocket;
        if (localSocket != null) {
            void var1_1;
            return var1_1.getInetAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int getLocalPort() {
        ServerSocket localSocket = this.serverSocket;
        if (localSocket != null) {
            void var1_1;
            return var1_1.getLocalPort();
        }
        return -1;
    }

    public void start() throws IOException {
        if (this.status.compareAndSet(Status.READY, Status.ACTIVE)) {
            this.serverSocket = this.serverSocketFactory.createServerSocket(this.port, this.socketConfig.getBacklogSize(), this.ifAddress);
            this.serverSocket.setReuseAddress(this.socketConfig.isSoReuseAddress());
            if (this.socketConfig.getRcvBufSize() > 0) {
                this.serverSocket.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
            }
            if (this.sslSetupHandler != null && this.serverSocket instanceof SSLServerSocket) {
                this.sslSetupHandler.initialize((SSLServerSocket)this.serverSocket);
            }
            this.requestListener = new RequestListener(this.socketConfig, this.serverSocket, this.httpService, this.connectionFactory, this.exceptionLogger, this.workerExecutorService);
            this.listenerExecutorService.execute(this.requestListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stop() {
        if (this.status.compareAndSet(Status.ACTIVE, Status.STOPPING)) {
            RequestListener local = this.requestListener;
            if (local != null) {
                try {
                    local.terminate();
                }
                catch (IOException ex) {
                    void var1_2;
                    this.exceptionLogger.log((Exception)var1_2);
                }
            }
            this.workerThreads.interrupt();
            this.listenerExecutorService.shutdown();
            this.workerExecutorService.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        void var3_2;
        void var1_1;
        this.workerExecutorService.awaitTermination((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown(long gracePeriod2, TimeUnit timeUnit) {
        this.stop();
        if (gracePeriod2 > 0L) {
            try {
                void var3_3;
                this.awaitTermination(gracePeriod2, (TimeUnit)var3_3);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        List<Runnable> gracePeriod2 = this.workerExecutorService.shutdownNow();
        for (Runnable runnable : gracePeriod2) {
            if (!(runnable instanceof Worker)) continue;
            runnable = (Worker)runnable;
            HttpServerConnection conn = ((Worker)runnable).getConnection();
            try {
                conn.shutdown();
            }
            catch (IOException ex) {
                void var2_5;
                this.exceptionLogger.log((Exception)var2_5);
            }
        }
    }

    static enum Status {
        READY,
        ACTIVE,
        STOPPING;

    }
}

