/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.util.Locale;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    /*
     * WARNING - void declaration
     */
    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        void var1_1;
        this.reasonCatalog = (ReasonPhraseCatalog)Args.notNull(var1_1, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        void var3_3;
        void var1_1;
        void var2_2;
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, (int)var2_2, reason);
        return new BasicHttpResponse((StatusLine)var1_1, this.reasonCatalog, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        void var2_2;
        void var1_1;
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse((StatusLine)var1_1, this.reasonCatalog, this.determineLocale((HttpContext)var2_2));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

