/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.RequestLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.Args;

@Immutable
public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    public static final DefaultHttpRequestFactory INSTANCE = new DefaultHttpRequestFactory();
    private static final String[] RFC2616_COMMON_METHODS = new String[]{"GET"};
    private static final String[] RFC2616_ENTITY_ENC_METHODS = new String[]{"POST", "PUT"};
    private static final String[] RFC2616_SPECIAL_METHODS = new String[]{"HEAD", "OPTIONS", "DELETE", "TRACE", "CONNECT"};

    private static boolean isOneOf(String[] methods, String method) {
        String[] arr$ = methods;
        int len$ = methods.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String string = arr$[i$];
            if (!string.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpRequest newHttpRequest(RequestLine requestline) throws MethodNotSupportedException {
        void var2_2;
        Args.notNull(requestline, "Request line");
        String method = requestline.getMethod();
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, method)) {
            return new BasicHttpRequest(requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, method)) {
            void var1_1;
            return new BasicHttpRequest((RequestLine)var1_1);
        }
        throw new MethodNotSupportedException((String)var2_2 + " method not supported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpRequest newHttpRequest(String method, String uri) throws MethodNotSupportedException {
        void var1_1;
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, method)) {
            return new BasicHttpRequest(method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, method)) {
            void var2_2;
            return new BasicHttpRequest(method, (String)var2_2);
        }
        throw new MethodNotSupportedException((String)var1_1 + " method not supported");
    }
}

