/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.BHttpConnectionBase;
import org.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.util.Args;

@NotThreadSafe
public class DefaultBHttpServerConnection
extends BHttpConnectionBase
implements HttpServerConnection {
    private final HttpMessageParser<HttpRequest> requestParser;
    private final HttpMessageWriter<HttpResponse> responseWriter;

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
        super((int)var1_1, (int)var2_2, (CharsetDecoder)var3_3, charencoder, constraints, incomingContentStrategy != null ? incomingContentStrategy : DisallowIdentityContentLengthStrategy.INSTANCE, outgoingContentStrategy);
        void var3_3;
        void var2_2;
        void var1_1;
        this.requestParser = (requestParserFactory != null ? requestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create(this.getSessionInputBuffer(), constraints);
        this.responseWriter = (responseWriterFactory != null ? responseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpServerConnection(int buffersize, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0, (CharsetDecoder)var2_2, (CharsetEncoder)var3_3, constraints, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpServerConnection(int buffersize) {
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0, null, null, null, null, null, null, null);
    }

    protected void onRequestReceived(HttpRequest request) {
    }

    protected void onResponseSubmitted(HttpResponse response) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(Socket socket) throws IOException {
        void var1_1;
        super.bind((Socket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        void var1_1;
        this.ensureOpen();
        HttpRequest request = this.requestParser.parse();
        this.onRequestReceived(request);
        this.incrementRequestCount();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var2_2;
        void var1_1;
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        HttpEntity entity = this.prepareInput(request);
        var1_1.setEntity((HttpEntity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        void var1_1;
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        this.responseWriter.write(response);
        this.onResponseSubmitted(response);
        if (var1_1.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var1_1;
        void var2_2;
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outstream = this.prepareOutput(response);
        var2_2.writeTo(outstream);
        var1_1.close();
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

