/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.BHttpConnectionBase;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.util.Args;

@NotThreadSafe
public class DefaultBHttpClientConnection
extends BHttpConnectionBase
implements HttpClientConnection {
    private final HttpMessageParser<HttpResponse> responseParser;
    private final HttpMessageWriter<HttpRequest> requestWriter;

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpClientConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super((int)var1_1, (int)var2_2, (CharsetDecoder)var3_3, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy);
        void var3_3;
        void var2_2;
        void var1_1;
        this.requestWriter = (requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
        this.responseParser = (responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.getSessionInputBuffer(), constraints);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpClientConnection(int buffersize, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0, (CharsetDecoder)var2_2, (CharsetEncoder)var3_3, constraints, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultBHttpClientConnection(int buffersize) {
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0, null, null, null, null, null, null, null);
    }

    protected void onResponseReceived(HttpResponse response) {
    }

    protected void onRequestSubmitted(HttpRequest request) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(Socket socket) throws IOException {
        void var1_1;
        super.bind((Socket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.ensureOpen();
        try {
            void var1_1;
            return this.awaitInput((int)var1_1);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        void var1_1;
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        this.requestWriter.write(request);
        this.onRequestSubmitted((HttpRequest)var1_1);
        this.incrementRequestCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var1_1;
        void var2_2;
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        HttpEntity entity = request.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outstream = this.prepareOutput(request);
        var2_2.writeTo(outstream);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        void var1_1;
        this.ensureOpen();
        HttpResponse response = this.responseParser.parse();
        this.onResponseReceived(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var2_2;
        void var1_1;
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        HttpEntity entity = this.prepareInput(response);
        var1_1.setEntity((HttpEntity)var2_2);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

