/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpMessage;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.impl.io.SessionOutputBufferImpl;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.NetUtils;

@NotThreadSafe
public class BHttpConnectionBase
implements HttpConnection,
HttpInetConnection {
    private final SessionInputBufferImpl inbuffer;
    private final SessionOutputBufferImpl outbuffer;
    private final MessageConstraints messageConstraints;
    private final HttpConnectionMetricsImpl connMetrics;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final AtomicReference<Socket> socketHolder;

    /*
     * WARNING - void declaration
     */
    protected BHttpConnectionBase(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints messageConstraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy) {
        void var2_2;
        void var1_1;
        void var3_3;
        Args.positive(buffersize, "Buffer size");
        HttpTransportMetricsImpl inTransportMetrics = new HttpTransportMetricsImpl();
        HttpTransportMetricsImpl outTransportMetrics = new HttpTransportMetricsImpl();
        this.inbuffer = new SessionInputBufferImpl(inTransportMetrics, buffersize, -1, messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT, (CharsetDecoder)var3_3);
        this.outbuffer = new SessionOutputBufferImpl(outTransportMetrics, (int)var1_1, (int)var2_2, charencoder);
        this.messageConstraints = messageConstraints;
        this.connMetrics = new HttpConnectionMetricsImpl(inTransportMetrics, outTransportMetrics);
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : StrictContentLengthStrategy.INSTANCE;
        this.socketHolder = new AtomicReference();
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureOpen() throws IOException {
        Socket socket = this.socketHolder.get();
        if (socket == null) {
            throw new ConnectionClosedException("Connection is closed");
        }
        if (!this.inbuffer.isBound()) {
            this.inbuffer.bind(this.getSocketInputStream(socket));
        }
        if (!this.outbuffer.isBound()) {
            void var1_1;
            this.outbuffer.bind(this.getSocketOutputStream((Socket)var1_1));
        }
    }

    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    /*
     * WARNING - void declaration
     */
    protected void bind(Socket socket) throws IOException {
        void var1_1;
        Args.notNull(socket, "Socket");
        this.socketHolder.set((Socket)var1_1);
        this.inbuffer.bind(null);
        this.outbuffer.bind(null);
    }

    protected SessionInputBuffer getSessionInputBuffer() {
        return this.inbuffer;
    }

    protected SessionOutputBuffer getSessionOutputBuffer() {
        return this.outbuffer;
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public boolean isOpen() {
        return this.socketHolder.get() != null;
    }

    protected Socket getSocket() {
        return this.socketHolder.get();
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStream createOutputStream(long len, SessionOutputBuffer outbuffer) {
        void var1_1;
        void var3_2;
        if (len == -2L) {
            return new ChunkedOutputStream(2048, outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream((SessionOutputBuffer)var3_2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStream prepareOutput(HttpMessage message) throws HttpException {
        void var2_2;
        void var1_1;
        long len = this.outgoingContentStrategy.determineLength((HttpMessage)var1_1);
        return this.createOutputStream((long)var2_2, this.outbuffer);
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream createInputStream(long len, SessionInputBuffer inbuffer) {
        void var1_1;
        void var3_2;
        if (len == -2L) {
            return new ChunkedInputStream(inbuffer, this.messageConstraints);
        }
        if (len == -1L) {
            return new IdentityInputStream(inbuffer);
        }
        if (len == 0L) {
            return EmptyInputStream.INSTANCE;
        }
        return new ContentLengthInputStream((SessionInputBuffer)var3_2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpEntity prepareInput(HttpMessage message) throws HttpException {
        void var2_2;
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.incomingContentStrategy.determineLength(message);
        InputStream instream = this.createInputStream(len, this.inbuffer);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(instream);
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(instream);
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(instream);
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            void var3_4;
            entity.setContentType((Header)var3_4);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            void var1_1;
            entity.setContentEncoding((Header)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getLocalAddress() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            void var1_1;
            return var1_1.getLocalAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getLocalPort() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            void var1_1;
            return var1_1.getLocalPort();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getRemoteAddress() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            void var1_1;
            return var1_1.getInetAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getRemotePort() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            void var1_1;
            return var1_1.getPort();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSocketTimeout(int timeout) {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            try {
                void var1_1;
                void var2_2;
                var2_2.setSoTimeout((int)var1_1);
                return;
            }
            catch (SocketException socketException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSocketTimeout() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            try {
                void var1_1;
                return var1_1.getSoTimeout();
            }
            catch (SocketException socketException) {
                return -1;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() throws IOException {
        Socket socket = this.socketHolder.getAndSet(null);
        if (socket != null) {
            try {
                socket.setSoLinger(true, 0);
            }
            catch (IOException iOException) {
                socket.close();
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            socket.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws IOException {
        Socket socket = this.socketHolder.getAndSet(null);
        if (socket != null) {
            try {
                this.inbuffer.clear();
                this.outbuffer.flush();
                try {
                    try {
                        socket.shutdownOutput();
                    }
                    catch (IOException iOException) {}
                    try {
                        socket.shutdownInput();
                    }
                    catch (IOException iOException) {}
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            socket.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int fillInputBuffer(int timeout) throws IOException {
        int n;
        Socket socket = this.socketHolder.get();
        int oldtimeout = socket.getSoTimeout();
        try {
            socket.setSoTimeout(n);
            n = this.inbuffer.fillBuffer();
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            var2_3.setSoTimeout((int)var3_4);
            throw throwable;
        }
        socket.setSoTimeout(oldtimeout);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean awaitInput(int timeout) throws IOException {
        void var1_1;
        if (this.inbuffer.hasBufferedData()) {
            return true;
        }
        this.fillInputBuffer((int)var1_1);
        return this.inbuffer.hasBufferedData();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        try {
            int n = this.fillInputBuffer(1);
            return n < 0;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void incrementRequestCount() {
        this.connMetrics.incrementRequestCount();
    }

    protected void incrementResponseCount() {
        this.connMetrics.incrementResponseCount();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.connMetrics;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        Socket socket = this.socketHolder.get();
        if (socket != null) {
            void var2_2;
            StringBuilder buffer = new StringBuilder();
            SocketAddress remoteAddress = socket.getRemoteSocketAddress();
            SocketAddress localAddress = socket.getLocalSocketAddress();
            if (remoteAddress != null && localAddress != null) {
                void var3_3;
                void var1_1;
                NetUtils.formatAddress(buffer, (SocketAddress)var1_1);
                buffer.append("<->");
                NetUtils.formatAddress(buffer, (SocketAddress)var3_3);
            }
            return var2_2.toString();
        }
        return "[Not bound]";
    }
}

