/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntityDeserializer;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.impl.io.HttpRequestWriter;
import org.apache.http.io.EofSensor;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

@Deprecated
@NotThreadSafe
public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inbuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpResponse> responseParser = null;
    private HttpMessageWriter<HttpRequest> requestWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultHttpResponseParser((SessionInputBuffer)var1_1, null, (HttpResponseFactory)var2_2, (HttpParams)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        void var2_2;
        void var1_1;
        return new HttpRequestWriter((SessionOutputBuffer)var1_1, null, (HttpParams)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        void var2_2;
        void var1_1;
        return new HttpConnectionMetricsImpl((HttpTransportMetrics)var1_1, (HttpTransportMetrics)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void init(SessionInputBuffer inbuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.inbuffer = Args.notNull(inbuffer, "Input session buffer");
        this.outbuffer = Args.notNull(outbuffer, "Output session buffer");
        if (inbuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)inbuffer);
        }
        this.responseParser = this.createResponseParser(inbuffer, this.createHttpResponseFactory(), params);
        this.requestWriter = this.createRequestWriter(outbuffer, (HttpParams)var3_3);
        this.metrics = this.createConnectionMetrics(var1_1.getMetrics(), var2_2.getMetrics());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        try {
            void var1_1;
            return this.inbuffer.isDataAvailable((int)var1_1);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        void var1_1;
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        this.requestWriter.write((HttpRequest)var1_1);
        this.metrics.incrementRequestCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var1_1;
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        void v0 = var1_1;
        this.entityserializer.serialize(this.outbuffer, (HttpMessage)v0, v0.getEntity());
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        void var1_1;
        this.assertOpen();
        HttpResponse response = this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var2_2;
        void var1_1;
        Args.notNull(response, "HTTP response");
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inbuffer, response);
        var1_1.setEntity((HttpEntity)var2_2);
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inbuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

