/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;

@NotThreadSafe
public class StringEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final byte[] content;

    /*
     * WARNING - void declaration
     */
    public StringEntity(String string, ContentType contentType) throws UnsupportedCharsetException {
        void var3_3;
        void var1_1;
        Args.notNull(string, "Source string");
        Charset charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        this.content = var1_1.getBytes((Charset)var3_3);
        if (contentType != null) {
            void var2_2;
            this.setContentType(var2_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public StringEntity(String string, String mimeType, String charset) throws UnsupportedEncodingException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull(string, "Source string");
        String mt = mimeType != null ? mimeType : "text/plain";
        String cs = charset != null ? charset : "ISO-8859-1";
        this.content = var1_1.getBytes(cs);
        this.setContentType((String)var2_2 + "; charset=" + (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StringEntity(String string, String charset) throws UnsupportedCharsetException {
        this((String)var1_1, ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), (String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringEntity(String string, Charset charset) {
        this((String)var1_1, ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), (Charset)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringEntity(String string) throws UnsupportedEncodingException {
        this((String)var1_1, ContentType.DEFAULT_TEXT);
        void var1_1;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        void var1_1;
        Args.notNull(outstream, "Output stream");
        outstream.write(this.content);
        var1_1.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

