/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.util.Args;

@NotThreadSafe
public class SerializableEntity
extends AbstractHttpEntity {
    private byte[] objSer;
    private Serializable objRef;

    /*
     * WARNING - void declaration
     */
    public SerializableEntity(Serializable ser, boolean bufferize) throws IOException {
        void var1_1;
        void var2_2;
        Args.notNull(ser, "Source object");
        if (var2_2 != false) {
            this.createBytes(ser);
            return;
        }
        this.objRef = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SerializableEntity(Serializable ser) {
        void var1_1;
        Args.notNull(ser, "Source object");
        this.objRef = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void createBytes(Serializable ser) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(var1_1);
        var3_3.flush();
        this.objSer = var2_2.toByteArray();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.objSer == null) {
            SerializableEntity serializableEntity = this;
            serializableEntity.createBytes(serializableEntity.objRef);
        }
        return new ByteArrayInputStream(this.objSer);
    }

    @Override
    public long getContentLength() {
        if (this.objSer == null) {
            return -1L;
        }
        return this.objSer.length;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isStreaming() {
        return this.objSer == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        void var1_1;
        Args.notNull(outstream, "Output stream");
        if (this.objSer == null) {
            ObjectOutputStream out = new ObjectOutputStream(outstream);
            out.writeObject(this.objRef);
            var1_1.flush();
            return;
        }
        var1_1.write(this.objSer);
        var1_1.flush();
    }
}

