/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

@NotThreadSafe
public class InputStreamEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    /*
     * WARNING - void declaration
     */
    public InputStreamEntity(InputStream instream) {
        this((InputStream)var1_1, -1L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InputStreamEntity(InputStream instream, long length) {
        this((InputStream)var1_1, (long)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InputStreamEntity(InputStream instream, ContentType contentType) {
        this((InputStream)var1_1, -1L, (ContentType)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InputStreamEntity(InputStream instream, long length, ContentType contentType) {
        void var2_2;
        void var1_1;
        this.content = (InputStream)Args.notNull(var1_1, "Source input stream");
        this.length = var2_2;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull(outstream, "Output stream");
        InputStream instream = this.content;
        try {
            byte[] buffer = new byte[4096];
            if (this.length < 0L) {
                int l;
                while ((l = instream.read(buffer)) != -1) {
                    outstream.write(buffer, 0, l);
                }
            } else {
                int l;
                for (long remaining = this.length; remaining > 0L && (l = instream.read(buffer, 0, (int)Math.min(4096L, remaining))) != -1; remaining -= (long)l) {
                    outstream.write(buffer, 0, l);
                }
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.close();
            throw throwable;
        }
        instream.close();
    }

    @Override
    public boolean isStreaming() {
        return true;
    }
}

