/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.TextUtils;

@Immutable
public final class ContentType
implements Serializable {
    private static final long serialVersionUID = -7768694718232371896L;
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", Consts.ISO_8859_1);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", Consts.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", Consts.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", null);
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", Consts.ISO_8859_1);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", Consts.ISO_8859_1);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", Consts.ISO_8859_1);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", Consts.ISO_8859_1);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", Consts.ISO_8859_1);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", Consts.ISO_8859_1);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", Consts.ISO_8859_1);
    public static final ContentType WILDCARD = ContentType.create("*/*", null);
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private final String mimeType;
    private final Charset charset;
    private final NameValuePair[] params;

    /*
     * WARNING - void declaration
     */
    ContentType(String mimeType, Charset charset) {
        void var2_2;
        void var1_1;
        this.mimeType = var1_1;
        this.charset = var2_2;
        this.params = null;
    }

    /*
     * WARNING - void declaration
     */
    ContentType(String mimeType, Charset charset, NameValuePair[] params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mimeType = var1_1;
        this.charset = var2_2;
        this.params = var3_3;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public final String getParameter(String name) {
        Args.notEmpty(name, "Parameter name");
        if (this.params == null) {
            return null;
        }
        NameValuePair[] arr$ = this.params;
        int len$ = this.params.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair param = arr$[i$];
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append(this.mimeType);
        if (this.params != null) {
            buf.append("; ");
            BasicHeaderValueFormatter.INSTANCE.formatParameters(buf, this.params, false);
        } else if (this.charset != null) {
            buf.append("; charset=");
            buf.append(this.charset.name());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean valid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            void var2_2;
            char ch = s.charAt(i);
            if (ch != '\"' && ch != ',' && var2_2 != 59) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static ContentType create(String mimeType, Charset charset) {
        void var1_1;
        String string;
        String type = Args.notBlank(mimeType, "MIME type").toLowerCase(Locale.ROOT);
        Args.check(ContentType.valid(type), "MIME type may not contain reserved characters");
        return new ContentType(string, (Charset)var1_1);
    }

    public static ContentType create(String mimeType) {
        String string;
        return new ContentType(string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static ContentType create(String mimeType, String charset) throws UnsupportedCharsetException {
        void var1_1;
        return ContentType.create(mimeType, !TextUtils.isBlank(charset) ? Charset.forName((String)var1_1) : null);
    }

    /*
     * WARNING - void declaration
     */
    private static ContentType create(HeaderElement helem, boolean strict) {
        void var1_1;
        HeaderElement headerElement;
        return ContentType.create(helem.getName(), headerElement.getParameters(), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ContentType create(String mimeType, NameValuePair[] params, boolean strict) {
        void var1_1;
        void var3_3;
        String string;
        Charset charset = null;
        NameValuePair[] arr$ = params;
        int len$ = params.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair param = arr$[i$];
            if (!param.getName().equalsIgnoreCase("charset")) continue;
            String s = param.getValue();
            if (TextUtils.isBlank(s)) break;
            try {
                charset = Charset.forName(s);
                break;
            }
            catch (UnsupportedCharsetException ex) {
                if (!strict) break;
                throw ex;
            }
        }
        return new ContentType(string, (Charset)var3_3, (NameValuePair[])(params != null && params.length > 0 ? var1_1 : null));
    }

    /*
     * WARNING - void declaration
     */
    public static ContentType create(String mimeType, NameValuePair ... params) throws UnsupportedCharsetException {
        void var1_1;
        String string;
        String string2 = Args.notBlank(mimeType, "MIME type").toLowerCase(Locale.ROOT);
        Args.check(ContentType.valid(string2), "MIME type may not contain reserved characters");
        return ContentType.create(string, (NameValuePair[])var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static ContentType parse(String s) throws ParseException, UnsupportedCharsetException {
        String string;
        void var2_2;
        Args.notNull(s, "Content type");
        CharArrayBuffer buf = new CharArrayBuffer(s.length());
        buf.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        HeaderElement[] elements = BasicHeaderValueParser.INSTANCE.parseElements(buf, (ParserCursor)var2_2);
        if (elements.length > 0) {
            void var1_1;
            return ContentType.create((HeaderElement)var1_1[0], true);
        }
        throw new ParseException("Invalid content type: " + string);
    }

    public static ContentType get(HttpEntity entity) throws ParseException, UnsupportedCharsetException {
        Object elements;
        if (entity == null) {
            return null;
        }
        Object header = entity.getContentType();
        if (header != null && ((HeaderElement[])(elements = header.getElements())).length > 0) {
            Object object;
            return ContentType.create(object[0], true);
        }
        return null;
    }

    public static ContentType getLenient(HttpEntity entity) {
        if (entity == null) {
            return null;
        }
        Object header = entity.getContentType();
        if (header != null) {
            try {
                Object elements = header.getElements();
                if (((HeaderElement[])elements).length > 0) {
                    Object object;
                    return ContentType.create(object[0], false);
                }
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public static ContentType getOrDefault(HttpEntity entity) throws ParseException, UnsupportedCharsetException {
        ContentType contentType = ContentType.get(entity);
        if (contentType != null) {
            ContentType contentType2;
            return contentType2;
        }
        return DEFAULT_TEXT;
    }

    public static ContentType getLenientOrDefault(HttpEntity entity) throws ParseException, UnsupportedCharsetException {
        ContentType contentType = ContentType.get(entity);
        if (contentType != null) {
            ContentType contentType2;
            return contentType2;
        }
        return DEFAULT_TEXT;
    }

    /*
     * WARNING - void declaration
     */
    public final ContentType withCharset(Charset charset) {
        void var1_1;
        return ContentType.create(this.getMimeType(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ContentType withCharset(String charset) {
        void var1_1;
        return ContentType.create(this.getMimeType(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ContentType withParameters(NameValuePair ... params) throws UnsupportedCharsetException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (params.length == 0) {
            return this;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        if (this.params != null) {
            NameValuePair[] arr$ = this.params;
            int len$ = this.params.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                NameValuePair param = arr$[i$];
                paramMap.put(param.getName(), param.getValue());
            }
        }
        for (NameValuePair param : var1_1) {
            paramMap.put(param.getName(), param.getValue());
        }
        ArrayList<BasicNameValuePair> newParams = new ArrayList<BasicNameValuePair>(paramMap.size() + 1);
        if (this.charset != null && !paramMap.containsKey("charset")) {
            newParams.add(new BasicNameValuePair("charset", this.charset.name()));
        }
        for (Map.Entry entry : var2_2.entrySet()) {
            newParams.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        void v0 = var3_3;
        return ContentType.create(this.getMimeType(), v0.toArray(new NameValuePair[v0.size()]), true);
    }
}

