/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

@NotThreadSafe
public class ByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    @Deprecated
    protected final byte[] content;
    private final byte[] b;
    private final int off;
    private final int len;

    /*
     * WARNING - void declaration
     */
    public ByteArrayEntity(byte[] b, ContentType contentType) {
        void var1_1;
        Args.notNull(b, "Source byte array");
        this.content = b;
        this.b = var1_1;
        this.off = 0;
        this.len = this.b.length;
        if (contentType != null) {
            void var2_2;
            this.setContentType(var2_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEntity(byte[] b, int off, int len, ContentType contentType) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull(b, "Source byte array");
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        this.content = b;
        this.b = var1_1;
        this.off = var2_2;
        this.len = var3_3;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEntity(byte[] b) {
        this((byte[])var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEntity(byte[] b, int off, int len) {
        this((byte[])var1_1, (int)var2_2, (int)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        void var1_1;
        Args.notNull(outstream, "Output stream");
        outstream.write(this.b, this.off, this.len);
        var1_1.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

