/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;

@Immutable
public class SocketConfig
implements Cloneable {
    public static final SocketConfig DEFAULT = new Builder().build();
    private final int soTimeout;
    private final boolean soReuseAddress;
    private final int soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int sndBufSize;
    private final int rcvBufSize;
    private int backlogSize;

    /*
     * WARNING - void declaration
     */
    SocketConfig(int soTimeout, boolean soReuseAddress, int soLinger, boolean soKeepAlive, boolean tcpNoDelay, int sndBufSize, int rcvBufSize, int backlogSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.soTimeout = var1_1;
        this.soReuseAddress = var2_2;
        this.soLinger = var3_3;
        this.soKeepAlive = soKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.sndBufSize = sndBufSize;
        this.rcvBufSize = rcvBufSize;
        this.backlogSize = backlogSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    protected SocketConfig clone() throws CloneNotSupportedException {
        return (SocketConfig)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append("]");
        return var1_1.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(SocketConfig config) {
        SocketConfig socketConfig;
        Args.notNull(config, "Socket config");
        return new Builder().setSoTimeout(config.getSoTimeout()).setSoReuseAddress(config.isSoReuseAddress()).setSoLinger(config.getSoLinger()).setSoKeepAlive(config.isSoKeepAlive()).setTcpNoDelay(config.isTcpNoDelay()).setSndBufSize(config.getSndBufSize()).setRcvBufSize(config.getRcvBufSize()).setBacklogSize(socketConfig.getBacklogSize());
    }

    public static class Builder {
        private int soTimeout;
        private boolean soReuseAddress;
        private int soLinger = -1;
        private boolean soKeepAlive;
        private boolean tcpNoDelay = true;
        private int sndBufSize;
        private int rcvBufSize;
        private int backlogSize;

        Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSoTimeout(int soTimeout) {
            void var1_1;
            this.soTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSoReuseAddress(boolean soReuseAddress) {
            void var1_1;
            this.soReuseAddress = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSoLinger(int soLinger) {
            void var1_1;
            this.soLinger = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSoKeepAlive(boolean soKeepAlive) {
            void var1_1;
            this.soKeepAlive = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTcpNoDelay(boolean tcpNoDelay) {
            void var1_1;
            this.tcpNoDelay = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSndBufSize(int sndBufSize) {
            void var1_1;
            this.sndBufSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRcvBufSize(int rcvBufSize) {
            void var1_1;
            this.rcvBufSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBacklogSize(int backlogSize) {
            void var1_1;
            this.backlogSize = var1_1;
            return this;
        }

        public SocketConfig build() {
            return new SocketConfig(this.soTimeout, this.soReuseAddress, this.soLinger, this.soKeepAlive, this.tcpNoDelay, this.sndBufSize, this.rcvBufSize, this.backlogSize);
        }
    }
}

