/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import org.apache.http.util.Args;

public class MessageConstraints
implements Cloneable {
    public static final MessageConstraints DEFAULT = new Builder().build();
    private final int maxLineLength;
    private final int maxHeaderCount;

    /*
     * WARNING - void declaration
     */
    MessageConstraints(int maxLineLength, int maxHeaderCount) {
        void var2_2;
        void var1_1;
        this.maxLineLength = var1_1;
        this.maxHeaderCount = var2_2;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    protected MessageConstraints clone() throws CloneNotSupportedException {
        return (MessageConstraints)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[maxLineLength=").append(this.maxLineLength).append(", maxHeaderCount=").append(this.maxHeaderCount).append("]");
        return var1_1.toString();
    }

    public static MessageConstraints lineLen(int max) {
        int n;
        return new MessageConstraints(Args.notNegative(n, "Max line length"), -1);
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(MessageConstraints config) {
        MessageConstraints messageConstraints;
        Args.notNull(config, "Message constraints");
        return new Builder().setMaxHeaderCount(config.getMaxHeaderCount()).setMaxLineLength(messageConstraints.getMaxLineLength());
    }

    public static class Builder {
        private int maxLineLength = -1;
        private int maxHeaderCount = -1;

        Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMaxLineLength(int maxLineLength) {
            void var1_1;
            this.maxLineLength = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMaxHeaderCount(int maxHeaderCount) {
            void var1_1;
            this.maxHeaderCount = var1_1;
            return this;
        }

        public MessageConstraints build() {
            return new MessageConstraints(this.maxLineLength, this.maxHeaderCount);
        }
    }
}

