/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.annotation.Immutable;
import org.apache.http.config.MessageConstraints;
import org.apache.http.util.Args;

@Immutable
public class ConnectionConfig
implements Cloneable {
    public static final ConnectionConfig DEFAULT = new Builder().build();
    private final int bufferSize;
    private final int fragmentSizeHint;
    private final Charset charset;
    private final CodingErrorAction malformedInputAction;
    private final CodingErrorAction unmappableInputAction;
    private final MessageConstraints messageConstraints;

    /*
     * WARNING - void declaration
     */
    ConnectionConfig(int bufferSize, int fragmentSizeHint, Charset charset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableInputAction, MessageConstraints messageConstraints) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bufferSize = var1_1;
        this.fragmentSizeHint = var2_2;
        this.charset = var3_3;
        this.malformedInputAction = malformedInputAction;
        this.unmappableInputAction = unmappableInputAction;
        this.messageConstraints = messageConstraints;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getFragmentSizeHint() {
        return this.fragmentSizeHint;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public CodingErrorAction getMalformedInputAction() {
        return this.malformedInputAction;
    }

    public CodingErrorAction getUnmappableInputAction() {
        return this.unmappableInputAction;
    }

    public MessageConstraints getMessageConstraints() {
        return this.messageConstraints;
    }

    protected ConnectionConfig clone() throws CloneNotSupportedException {
        return (ConnectionConfig)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[bufferSize=").append(this.bufferSize).append(", fragmentSizeHint=").append(this.fragmentSizeHint).append(", charset=").append(this.charset).append(", malformedInputAction=").append(this.malformedInputAction).append(", unmappableInputAction=").append(this.unmappableInputAction).append(", messageConstraints=").append(this.messageConstraints).append("]");
        return var1_1.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(ConnectionConfig config) {
        ConnectionConfig connectionConfig;
        Args.notNull(config, "Connection config");
        return new Builder().setCharset(config.getCharset()).setMalformedInputAction(config.getMalformedInputAction()).setUnmappableInputAction(config.getUnmappableInputAction()).setMessageConstraints(connectionConfig.getMessageConstraints());
    }

    public static class Builder {
        private int bufferSize;
        private int fragmentSizeHint = -1;
        private Charset charset;
        private CodingErrorAction malformedInputAction;
        private CodingErrorAction unmappableInputAction;
        private MessageConstraints messageConstraints;

        Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFragmentSizeHint(int fragmentSizeHint) {
            void var1_1;
            this.fragmentSizeHint = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCharset(Charset charset) {
            void var1_1;
            this.charset = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMalformedInputAction(CodingErrorAction malformedInputAction) {
            void var1_1;
            this.malformedInputAction = malformedInputAction;
            if (var1_1 != null && this.charset == null) {
                this.charset = Consts.ASCII;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUnmappableInputAction(CodingErrorAction unmappableInputAction) {
            void var1_1;
            this.unmappableInputAction = unmappableInputAction;
            if (var1_1 != null && this.charset == null) {
                this.charset = Consts.ASCII;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMessageConstraints(MessageConstraints messageConstraints) {
            void var1_1;
            this.messageConstraints = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ConnectionConfig build() {
            void var1_1;
            void var3_3;
            void var2_2;
            Charset cs = this.charset;
            if (cs == null && (this.malformedInputAction != null || this.unmappableInputAction != null)) {
                cs = Consts.ASCII;
            }
            int bufSize = this.bufferSize > 0 ? this.bufferSize : 8192;
            int fragmentHintSize = this.fragmentSizeHint >= 0 ? this.fragmentSizeHint : bufSize;
            return new ConnectionConfig((int)var2_2, (int)var3_3, (Charset)var1_1, this.malformedInputAction, this.unmappableInputAction, this.messageConstraints);
        }
    }
}

