/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.Serializable;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;

@Immutable
public class ProtocolVersion
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8950662842175091068L;
    protected final String protocol;
    protected final int major;
    protected final int minor;

    /*
     * WARNING - void declaration
     */
    public ProtocolVersion(String protocol, int major, int minor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.protocol = (String)Args.notNull(var1_1, "Protocol name");
        this.major = Args.notNegative((int)var2_2, "Protocol minor version");
        this.minor = Args.notNegative((int)var3_3, "Protocol minor version");
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    /*
     * WARNING - void declaration
     */
    public ProtocolVersion forVersion(int major, int minor) {
        void var2_2;
        void var1_1;
        if (major == this.major && minor == this.minor) {
            return this;
        }
        return new ProtocolVersion(this.protocol, (int)var1_1, (int)var2_2);
    }

    public final int hashCode() {
        return this.protocol.hashCode() ^ this.major * 100000 ^ this.minor;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion that = (ProtocolVersion)obj;
        return this.protocol.equals(that.protocol) && this.major == that.major && this.minor == var1_1.minor;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isComparable(ProtocolVersion that) {
        void var1_1;
        return that != null && this.protocol.equals(var1_1.protocol);
    }

    /*
     * WARNING - void declaration
     */
    public int compareToVersion(ProtocolVersion that) {
        void var2_2;
        Args.notNull(that, "Protocol version");
        Args.check(this.protocol.equals(that.protocol), "Versions for different protocols cannot be compared: %s %s", this, that);
        int delta = this.getMajor() - that.getMajor();
        if (delta == 0) {
            void var1_1;
            delta = this.getMinor() - var1_1.getMinor();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean greaterEquals(ProtocolVersion version) {
        void var1_1;
        return this.isComparable(version) && this.compareToVersion((ProtocolVersion)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean lessEquals(ProtocolVersion version) {
        void var1_1;
        return this.isComparable(version) && this.compareToVersion((ProtocolVersion)var1_1) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.protocol);
        buffer.append('/');
        buffer.append(Integer.toString(this.major));
        buffer.append('.');
        buffer.append(Integer.toString(this.minor));
        return var1_1.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

