/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Immutable
public final class HttpHost
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final String DEFAULT_SCHEME_NAME = "http";
    protected final String hostname;
    protected final String lcHostname;
    protected final int port;
    protected final String schemeName;
    protected final InetAddress address;

    /*
     * WARNING - void declaration
     */
    public HttpHost(String hostname, int port, String scheme) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.hostname = Args.containsNoBlanks(hostname, "Host name");
        this.lcHostname = var1_1.toLowerCase(Locale.ROOT);
        this.schemeName = scheme != null ? var3_3.toLowerCase(Locale.ROOT) : DEFAULT_SCHEME_NAME;
        this.port = var2_2;
        this.address = null;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(String hostname, int port) {
        this((String)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HttpHost create(String s) {
        void var1_1;
        void var2_2;
        String string;
        String text;
        Args.containsNoBlanks(s, "HTTP Host");
        String scheme = null;
        int schemeIdx = text.indexOf("://");
        if (schemeIdx > 0) {
            scheme = text.substring(0, schemeIdx);
            text = text.substring(schemeIdx + 3);
        }
        int port = -1;
        int portIdx = text.lastIndexOf(":");
        if (portIdx > 0) {
            void var3_3;
            try {
                port = Integer.parseInt(text.substring(portIdx + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid HTTP host: " + text);
            }
            text = text.substring(0, (int)var3_3);
        }
        return new HttpHost(string, (int)var2_2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(String hostname) {
        this((String)var1_1, -1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(InetAddress address, int port, String scheme) {
        this(Args.notNull(address, "Inet address"), var1_1.getHostName(), (int)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(InetAddress address, String hostname, int port, String scheme) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.address = (InetAddress)Args.notNull(var1_1, "Inet address");
        this.hostname = (String)Args.notNull(var2_2, "Hostname");
        this.lcHostname = this.hostname.toLowerCase(Locale.ROOT);
        this.schemeName = scheme != null ? scheme.toLowerCase(Locale.ROOT) : DEFAULT_SCHEME_NAME;
        this.port = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(InetAddress address, int port) {
        this((InetAddress)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(InetAddress address) {
        this((InetAddress)var1_1, -1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpHost(HttpHost httphost) {
        void var1_1;
        Args.notNull(httphost, "HTTP host");
        this.hostname = httphost.hostname;
        this.lcHostname = httphost.lcHostname;
        this.schemeName = httphost.schemeName;
        this.port = httphost.port;
        this.address = var1_1.address;
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getSchemeName() {
        return this.schemeName;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - void declaration
     */
    public final String toURI() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.schemeName);
        buffer.append("://");
        buffer.append(this.hostname);
        if (this.port != -1) {
            buffer.append(':');
            buffer.append(Integer.toString(this.port));
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String toHostString() {
        if (this.port != -1) {
            void var1_1;
            StringBuilder buffer = new StringBuilder(this.hostname.length() + 6);
            buffer.append(this.hostname);
            buffer.append(":");
            buffer.append(Integer.toString(this.port));
            return var1_1.toString();
        }
        return this.hostname;
    }

    public final String toString() {
        return this.toURI();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpHost) {
            void var1_1;
            HttpHost that = (HttpHost)obj;
            return this.lcHostname.equals(that.lcHostname) && this.port == that.port && this.schemeName.equals(that.schemeName) && (this.address == null ? that.address == null : this.address.equals(var1_1.address));
        }
        return false;
    }

    public final int hashCode() {
        int n = LangUtils.hashCode(17, this.lcHostname);
        n = LangUtils.hashCode(n, this.port);
        int hash = LangUtils.hashCode(n, this.schemeName);
        if (this.address != null) {
            hash = LangUtils.hashCode(hash, this.address);
        }
        return n;
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

